/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;

@OpMetadata(opType="LearnedUnigramCandidateSampler", inputsClass=Inputs.class)
public final class LearnedUnigramCandidateSampler
extends RawOp {
    public static final String OP_NAME = "LearnedUnigramCandidateSampler";
    private Output<TInt64> sampledCandidates;
    private Output<TFloat32> trueExpectedCount;
    private Output<TFloat32> sampledExpectedCount;

    public LearnedUnigramCandidateSampler(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.sampledCandidates = operation.output(outputIdx++);
        this.trueExpectedCount = operation.output(outputIdx++);
        this.sampledExpectedCount = operation.output(outputIdx++);
    }

    public static LearnedUnigramCandidateSampler create(Scope scope, Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(trueClasses.asOutput());
        opBuilder.setAttr("num_true", numTrue);
        opBuilder.setAttr("num_sampled", numSampled);
        opBuilder.setAttr("unique", unique);
        opBuilder.setAttr("range_max", rangeMax);
        if (options != null) {
            for (Options opts : options) {
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new LearnedUnigramCandidateSampler(opBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<TInt64> sampledCandidates() {
        return this.sampledCandidates;
    }

    public Output<TFloat32> trueExpectedCount() {
        return this.trueExpectedCount;
    }

    public Output<TFloat32> sampledExpectedCount() {
        return this.sampledExpectedCount;
    }

    @OpInputsMetadata(outputsClass=LearnedUnigramCandidateSampler.class)
    public static class Inputs
    extends RawOpInputs<LearnedUnigramCandidateSampler> {
        public final Operand<TInt64> trueClasses;
        public final long numTrue;
        public final long numSampled;
        public final boolean unique;
        public final long rangeMax;
        public final long seed;
        public final long seed2;

        public Inputs(GraphOperation op) {
            super(new LearnedUnigramCandidateSampler(op), op, Arrays.asList("num_true", "num_sampled", "unique", "range_max", "seed", "seed2"));
            int inputIndex = 0;
            this.trueClasses = op.input(inputIndex++);
            this.numTrue = op.attributes().getAttrInt("num_true");
            this.numSampled = op.attributes().getAttrInt("num_sampled");
            this.unique = op.attributes().getAttrBool("unique");
            this.rangeMax = op.attributes().getAttrInt("range_max");
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
        }
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        private Options() {
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }
    }
}

