/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.collective;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="CollectiveInitializeCommunicator", inputsClass=Inputs.class)
public final class CollectiveInitializeCommunicator
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "CollectiveInitializeCommunicator";
    private Output<? extends TType> communicator;

    public CollectiveInitializeCommunicator(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.communicator = operation.output(outputIdx++);
    }

    public static CollectiveInitializeCommunicator create(Scope scope, Operand<TInt32> groupKey, Operand<TInt32> rank, Operand<TInt32> groupSize, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(groupKey.asOutput());
        opBuilder.addInput(rank.asOutput());
        opBuilder.addInput(groupSize.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.communicationHint != null) {
                    opBuilder.setAttr("communication_hint", opts.communicationHint);
                }
                if (opts.timeoutSeconds == null) continue;
                opBuilder.setAttr("timeout_seconds", opts.timeoutSeconds.floatValue());
            }
        }
        return new CollectiveInitializeCommunicator(opBuilder.build());
    }

    public static Options communicationHint(String communicationHint) {
        return new Options().communicationHint(communicationHint);
    }

    public static Options timeoutSeconds(Float timeoutSeconds) {
        return new Options().timeoutSeconds(timeoutSeconds);
    }

    public Output<? extends TType> communicator() {
        return this.communicator;
    }

    @Override
    public Output<TType> asOutput() {
        return this.communicator;
    }

    @OpInputsMetadata(outputsClass=CollectiveInitializeCommunicator.class)
    public static class Inputs
    extends RawOpInputs<CollectiveInitializeCommunicator> {
        public final Operand<TInt32> groupKey;
        public final Operand<TInt32> rank;
        public final Operand<TInt32> groupSize;
        public final String communicationHint;
        public final float timeoutSeconds;

        public Inputs(GraphOperation op) {
            super(new CollectiveInitializeCommunicator(op), op, Arrays.asList("communication_hint", "timeout_seconds"));
            int inputIndex = 0;
            this.groupKey = op.input(inputIndex++);
            this.rank = op.input(inputIndex++);
            this.groupSize = op.input(inputIndex++);
            this.communicationHint = op.attributes().getAttrString("communication_hint");
            this.timeoutSeconds = op.attributes().getAttrFloat("timeout_seconds");
        }
    }

    public static class Options {
        private String communicationHint;
        private Float timeoutSeconds;

        private Options() {
        }

        public Options communicationHint(String communicationHint) {
            this.communicationHint = communicationHint;
            return this;
        }

        public Options timeoutSeconds(Float timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }
    }
}

