/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse.slice;

import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.dimension.RelativeDimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.SparseSlice;
import org.tensorflow.ndarray.index.Index;

public class LongSparseSlice
extends SparseSlice<Long, LongNdArray>
implements LongNdArray {
    public LongSparseSlice(AbstractSparseNdArray<Long, LongNdArray> source, long sourcePosition, DimensionalSpace dimensions) {
        super(source, sourcePosition, dimensions);
    }

    @Override
    public LongNdArray toDense() {
        LongDataBuffer dataBuffer = DataBuffers.ofLongs(this.shape().size());
        this.read(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    @Override
    public long getLong(long ... coordinates) {
        return (Long)this.getObject(coordinates);
    }

    @Override
    public LongNdArray setLong(long value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongNdArray setObject(Long value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongNdArray set(NdArray<Long> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongNdArray read(DataBuffer<Long> dst) {
        Object[] defaults = new Long[(int)this.shape().size()];
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write((Long[])defaults);
        AtomicLong i = new AtomicLong();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            long value = ((LongNdArray)this.getValues()).getLong(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public LongNdArray read(LongDataBuffer dst) {
        return this.read((DataBuffer)dst);
    }

    @Override
    public LongNdArray write(DataBuffer<Long> src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongNdArray write(LongDataBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongNdArray slice(Index ... indices) {
        if (indices == null) {
            throw new IllegalArgumentException("Slicing requires at least one index");
        }
        RelativeDimensionalSpace sliceDimensions = this.dimensions().mapTo(indices);
        return this.slice(sliceDimensions.position(), sliceDimensions);
    }

    @Override
    public LongNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new LongSparseSlice(this.source, position + this.sourcePosition, sliceDimensions);
    }

    @Override
    public LongNdArray get(long ... coordinates) {
        return (LongNdArray)super.get(coordinates);
    }

    @Override
    public LongNdArray copyTo(NdArray<Long> dst) {
        return (LongNdArray)super.copyTo(dst);
    }

    @Override
    public LongNdArray createDefaultArray() {
        return (LongNdArray)this.source.getDefaultArray();
    }
}

