/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaVariadicSort", inputsClass=Inputs.class)
public final class XlaVariadicSort
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "XlaVariadicSort";
    private List<Output<?>> outputs;

    public XlaVariadicSort(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }

    public static XlaVariadicSort create(Scope scope, Iterable<Operand<?>> inputs, Operand<TInt32> dimension, ConcreteFunction comparator, Boolean isStable) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(inputs));
        opBuilder.addInput(dimension.asOutput());
        opBuilder.setAttr("comparator", comparator);
        opBuilder.setAttr("is_stable", isStable);
        return new XlaVariadicSort(opBuilder.build());
    }

    public List<Output<?>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.outputs.iterator();
    }

    @OpInputsMetadata(outputsClass=XlaVariadicSort.class)
    public static class Inputs
    extends RawOpInputs<XlaVariadicSort> {
        public final Iterable<Operand<?>> inputs;
        public final Operand<TInt32> dimension;
        public final DataType[] T;
        public final boolean isStable;

        public Inputs(GraphOperation op) {
            super(new XlaVariadicSort(op), op, Arrays.asList("T", "is_stable"));
            int inputIndex = 0;
            int inputsLength = op.inputListLength("inputs");
            this.inputs = Arrays.asList((Operand[])op.inputList(inputIndex, inputsLength));
            inputIndex += inputsLength;
            this.dimension = op.input(inputIndex++);
            this.T = op.attributes().getAttrTypeList("T");
            this.isStable = op.attributes().getAttrBool("is_stable");
        }
    }
}

