/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaSvd", inputsClass=Inputs.class)
public final class Svd<T extends TType>
extends RawOp {
    public static final String OP_NAME = "XlaSvd";
    private Output<T> s;
    private Output<T> u;
    private Output<T> v;

    public Svd(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.s = operation.output(outputIdx++);
        this.u = operation.output(outputIdx++);
        this.v = operation.output(outputIdx++);
    }

    public static <T extends TType> Svd<T> create(Scope scope, Operand<T> a, Long maxIter, Float epsilon, String precisionConfig) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Svd");
        opBuilder.addInput(a.asOutput());
        opBuilder.setAttr("max_iter", maxIter);
        opBuilder.setAttr("epsilon", epsilon.floatValue());
        opBuilder.setAttr("precision_config", precisionConfig);
        return new Svd<T>(opBuilder.build());
    }

    public Output<T> s() {
        return this.s;
    }

    public Output<T> u() {
        return this.u;
    }

    public Output<T> v() {
        return this.v;
    }

    @OpInputsMetadata(outputsClass=Svd.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Svd<T>> {
        public final Operand<T> a;
        public final long maxIter;
        public final float epsilon;
        public final String precisionConfig;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new Svd(op), op, Arrays.asList("max_iter", "epsilon", "precision_config", "T"));
            int inputIndex = 0;
            this.a = op.input(inputIndex++);
            this.maxIter = op.attributes().getAttrInt("max_iter");
            this.epsilon = op.attributes().getAttrFloat("epsilon");
            this.precisionConfig = op.attributes().getAttrString("precision_config");
            this.T = op.attributes().getAttrType("T");
        }
    }
}

