/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;
import org.tensorflow.types.TUint8;

@OpMetadata(opType="EncodeJpeg", inputsClass=Inputs.class)
public final class EncodeJpeg
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "EncodeJpeg";
    private Output<TString> contents;

    public EncodeJpeg(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.contents = operation.output(outputIdx++);
    }

    public static EncodeJpeg create(Scope scope, Operand<TUint8> image, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(image.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.format != null) {
                    opBuilder.setAttr("format", opts.format);
                }
                if (opts.quality != null) {
                    opBuilder.setAttr("quality", opts.quality);
                }
                if (opts.progressive != null) {
                    opBuilder.setAttr("progressive", opts.progressive);
                }
                if (opts.optimizeSize != null) {
                    opBuilder.setAttr("optimize_size", opts.optimizeSize);
                }
                if (opts.chromaDownsampling != null) {
                    opBuilder.setAttr("chroma_downsampling", opts.chromaDownsampling);
                }
                if (opts.densityUnit != null) {
                    opBuilder.setAttr("density_unit", opts.densityUnit);
                }
                if (opts.xDensity != null) {
                    opBuilder.setAttr("x_density", opts.xDensity);
                }
                if (opts.yDensity != null) {
                    opBuilder.setAttr("y_density", opts.yDensity);
                }
                if (opts.xmpMetadata == null) continue;
                opBuilder.setAttr("xmp_metadata", opts.xmpMetadata);
            }
        }
        return new EncodeJpeg(opBuilder.build());
    }

    public static Options format(String format) {
        return new Options().format(format);
    }

    public static Options quality(Long quality) {
        return new Options().quality(quality);
    }

    public static Options progressive(Boolean progressive) {
        return new Options().progressive(progressive);
    }

    public static Options optimizeSize(Boolean optimizeSize) {
        return new Options().optimizeSize(optimizeSize);
    }

    public static Options chromaDownsampling(Boolean chromaDownsampling) {
        return new Options().chromaDownsampling(chromaDownsampling);
    }

    public static Options densityUnit(String densityUnit) {
        return new Options().densityUnit(densityUnit);
    }

    public static Options xDensity(Long xDensity) {
        return new Options().xDensity(xDensity);
    }

    public static Options yDensity(Long yDensity) {
        return new Options().yDensity(yDensity);
    }

    public static Options xmpMetadata(String xmpMetadata) {
        return new Options().xmpMetadata(xmpMetadata);
    }

    public Output<TString> contents() {
        return this.contents;
    }

    @Override
    public Output<TString> asOutput() {
        return this.contents;
    }

    @OpInputsMetadata(outputsClass=EncodeJpeg.class)
    public static class Inputs
    extends RawOpInputs<EncodeJpeg> {
        public final Operand<TUint8> image;
        public final String format;
        public final long quality;
        public final boolean progressive;
        public final boolean optimizeSize;
        public final boolean chromaDownsampling;
        public final String densityUnit;
        public final long xDensity;
        public final long yDensity;
        public final String xmpMetadata;

        public Inputs(GraphOperation op) {
            super(new EncodeJpeg(op), op, Arrays.asList("format", "quality", "progressive", "optimize_size", "chroma_downsampling", "density_unit", "x_density", "y_density", "xmp_metadata"));
            int inputIndex = 0;
            this.image = op.input(inputIndex++);
            this.format = op.attributes().getAttrString("format");
            this.quality = op.attributes().getAttrInt("quality");
            this.progressive = op.attributes().getAttrBool("progressive");
            this.optimizeSize = op.attributes().getAttrBool("optimize_size");
            this.chromaDownsampling = op.attributes().getAttrBool("chroma_downsampling");
            this.densityUnit = op.attributes().getAttrString("density_unit");
            this.xDensity = op.attributes().getAttrInt("x_density");
            this.yDensity = op.attributes().getAttrInt("y_density");
            this.xmpMetadata = op.attributes().getAttrString("xmp_metadata");
        }
    }

    public static class Options {
        private String format;
        private Long quality;
        private Boolean progressive;
        private Boolean optimizeSize;
        private Boolean chromaDownsampling;
        private String densityUnit;
        private Long xDensity;
        private Long yDensity;
        private String xmpMetadata;

        private Options() {
        }

        public Options format(String format) {
            this.format = format;
            return this;
        }

        public Options quality(Long quality) {
            this.quality = quality;
            return this;
        }

        public Options progressive(Boolean progressive) {
            this.progressive = progressive;
            return this;
        }

        public Options optimizeSize(Boolean optimizeSize) {
            this.optimizeSize = optimizeSize;
            return this;
        }

        public Options chromaDownsampling(Boolean chromaDownsampling) {
            this.chromaDownsampling = chromaDownsampling;
            return this;
        }

        public Options densityUnit(String densityUnit) {
            this.densityUnit = densityUnit;
            return this;
        }

        public Options xDensity(Long xDensity) {
            this.xDensity = xDensity;
            return this;
        }

        public Options yDensity(Long yDensity) {
            this.yDensity = yDensity;
            return this;
        }

        public Options xmpMetadata(String xmpMetadata) {
            this.xmpMetadata = xmpMetadata;
            return this;
        }
    }
}

