/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.StandbyWorkspace;
import software.amazon.awssdk.services.workspaces.model.StandbyWorkspacesListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStandbyWorkspacesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, CreateStandbyWorkspacesRequest> {
    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryRegion").getter(CreateStandbyWorkspacesRequest.getter(CreateStandbyWorkspacesRequest::primaryRegion)).setter(CreateStandbyWorkspacesRequest.setter(Builder::primaryRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryRegion").build()}).build();
    private static final SdkField<List<StandbyWorkspace>> STANDBY_WORKSPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StandbyWorkspaces").getter(CreateStandbyWorkspacesRequest.getter(CreateStandbyWorkspacesRequest::standbyWorkspaces)).setter(CreateStandbyWorkspacesRequest.setter(Builder::standbyWorkspaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandbyWorkspaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StandbyWorkspace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_REGION_FIELD, STANDBY_WORKSPACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PrimaryRegion", PRIMARY_REGION_FIELD);
            this.put("StandbyWorkspaces", STANDBY_WORKSPACES_FIELD);
        }
    });
    private final String primaryRegion;
    private final List<StandbyWorkspace> standbyWorkspaces;

    private CreateStandbyWorkspacesRequest(BuilderImpl builder) {
        super(builder);
        this.primaryRegion = builder.primaryRegion;
        this.standbyWorkspaces = builder.standbyWorkspaces;
    }

    public final String primaryRegion() {
        return this.primaryRegion;
    }

    public final boolean hasStandbyWorkspaces() {
        return this.standbyWorkspaces != null && !(this.standbyWorkspaces instanceof SdkAutoConstructList);
    }

    public final List<StandbyWorkspace> standbyWorkspaces() {
        return this.standbyWorkspaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStandbyWorkspaces() ? this.standbyWorkspaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStandbyWorkspacesRequest)) {
            return false;
        }
        CreateStandbyWorkspacesRequest other = (CreateStandbyWorkspacesRequest)((Object)obj);
        return Objects.equals(this.primaryRegion(), other.primaryRegion()) && this.hasStandbyWorkspaces() == other.hasStandbyWorkspaces() && Objects.equals(this.standbyWorkspaces(), other.standbyWorkspaces());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStandbyWorkspacesRequest").add("PrimaryRegion", (Object)this.primaryRegion()).add("StandbyWorkspaces", this.hasStandbyWorkspaces() ? this.standbyWorkspaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryRegion": {
                return Optional.ofNullable(clazz.cast(this.primaryRegion()));
            }
            case "StandbyWorkspaces": {
                return Optional.ofNullable(clazz.cast(this.standbyWorkspaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateStandbyWorkspacesRequest, T> g) {
        return obj -> g.apply((CreateStandbyWorkspacesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String primaryRegion;
        private List<StandbyWorkspace> standbyWorkspaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStandbyWorkspacesRequest model) {
            super(model);
            this.primaryRegion(model.primaryRegion);
            this.standbyWorkspaces(model.standbyWorkspaces);
        }

        public final String getPrimaryRegion() {
            return this.primaryRegion;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        @Override
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        public final List<StandbyWorkspace.Builder> getStandbyWorkspaces() {
            List<StandbyWorkspace.Builder> result = StandbyWorkspacesListCopier.copyToBuilder(this.standbyWorkspaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStandbyWorkspaces(Collection<StandbyWorkspace.BuilderImpl> standbyWorkspaces) {
            this.standbyWorkspaces = StandbyWorkspacesListCopier.copyFromBuilder(standbyWorkspaces);
        }

        @Override
        public final Builder standbyWorkspaces(Collection<StandbyWorkspace> standbyWorkspaces) {
            this.standbyWorkspaces = StandbyWorkspacesListCopier.copy(standbyWorkspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standbyWorkspaces(StandbyWorkspace ... standbyWorkspaces) {
            this.standbyWorkspaces(Arrays.asList(standbyWorkspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standbyWorkspaces(Consumer<StandbyWorkspace.Builder> ... standbyWorkspaces) {
            this.standbyWorkspaces(Stream.of(standbyWorkspaces).map(c -> (StandbyWorkspace)((StandbyWorkspace.Builder)StandbyWorkspace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStandbyWorkspacesRequest build() {
            return new CreateStandbyWorkspacesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStandbyWorkspacesRequest> {
        public Builder primaryRegion(String var1);

        public Builder standbyWorkspaces(Collection<StandbyWorkspace> var1);

        public Builder standbyWorkspaces(StandbyWorkspace ... var1);

        public Builder standbyWorkspaces(Consumer<StandbyWorkspace.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

