/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessPropertyValue {
    ALLOW("ALLOW"),
    DENY("DENY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessPropertyValue> VALUE_MAP;
    private final String value;

    private AccessPropertyValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessPropertyValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessPropertyValue> knownValues() {
        EnumSet<AccessPropertyValue> knownValues = EnumSet.allOf(AccessPropertyValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessPropertyValue.class, AccessPropertyValue::toString);
    }
}

