/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.PersonalAccessTokenSummary;
import software.amazon.awssdk.services.workmail.model.PersonalAccessTokenSummaryListCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPersonalAccessTokensResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, ListPersonalAccessTokensResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPersonalAccessTokensResponse.getter(ListPersonalAccessTokensResponse::nextToken)).setter(ListPersonalAccessTokensResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<PersonalAccessTokenSummary>> PERSONAL_ACCESS_TOKEN_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PersonalAccessTokenSummaries").getter(ListPersonalAccessTokensResponse.getter(ListPersonalAccessTokensResponse::personalAccessTokenSummaries)).setter(ListPersonalAccessTokensResponse.setter(Builder::personalAccessTokenSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalAccessTokenSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PersonalAccessTokenSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PERSONAL_ACCESS_TOKEN_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("PersonalAccessTokenSummaries", PERSONAL_ACCESS_TOKEN_SUMMARIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<PersonalAccessTokenSummary> personalAccessTokenSummaries;

    private ListPersonalAccessTokensResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.personalAccessTokenSummaries = builder.personalAccessTokenSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPersonalAccessTokenSummaries() {
        return this.personalAccessTokenSummaries != null && !(this.personalAccessTokenSummaries instanceof SdkAutoConstructList);
    }

    public final List<PersonalAccessTokenSummary> personalAccessTokenSummaries() {
        return this.personalAccessTokenSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPersonalAccessTokenSummaries() ? this.personalAccessTokenSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPersonalAccessTokensResponse)) {
            return false;
        }
        ListPersonalAccessTokensResponse other = (ListPersonalAccessTokensResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPersonalAccessTokenSummaries() == other.hasPersonalAccessTokenSummaries() && Objects.equals(this.personalAccessTokenSummaries(), other.personalAccessTokenSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListPersonalAccessTokensResponse").add("NextToken", (Object)this.nextToken()).add("PersonalAccessTokenSummaries", this.hasPersonalAccessTokenSummaries() ? this.personalAccessTokenSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PersonalAccessTokenSummaries": {
                return Optional.ofNullable(clazz.cast(this.personalAccessTokenSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPersonalAccessTokensResponse, T> g) {
        return obj -> g.apply((ListPersonalAccessTokensResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PersonalAccessTokenSummary> personalAccessTokenSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPersonalAccessTokensResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.personalAccessTokenSummaries(model.personalAccessTokenSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PersonalAccessTokenSummary.Builder> getPersonalAccessTokenSummaries() {
            List<PersonalAccessTokenSummary.Builder> result = PersonalAccessTokenSummaryListCopier.copyToBuilder(this.personalAccessTokenSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPersonalAccessTokenSummaries(Collection<PersonalAccessTokenSummary.BuilderImpl> personalAccessTokenSummaries) {
            this.personalAccessTokenSummaries = PersonalAccessTokenSummaryListCopier.copyFromBuilder(personalAccessTokenSummaries);
        }

        @Override
        public final Builder personalAccessTokenSummaries(Collection<PersonalAccessTokenSummary> personalAccessTokenSummaries) {
            this.personalAccessTokenSummaries = PersonalAccessTokenSummaryListCopier.copy(personalAccessTokenSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personalAccessTokenSummaries(PersonalAccessTokenSummary ... personalAccessTokenSummaries) {
            this.personalAccessTokenSummaries(Arrays.asList(personalAccessTokenSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personalAccessTokenSummaries(Consumer<PersonalAccessTokenSummary.Builder> ... personalAccessTokenSummaries) {
            this.personalAccessTokenSummaries(Stream.of(personalAccessTokenSummaries).map(c -> (PersonalAccessTokenSummary)((PersonalAccessTokenSummary.Builder)PersonalAccessTokenSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPersonalAccessTokensResponse build() {
            return new ListPersonalAccessTokensResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPersonalAccessTokensResponse> {
        public Builder nextToken(String var1);

        public Builder personalAccessTokenSummaries(Collection<PersonalAccessTokenSummary> var1);

        public Builder personalAccessTokenSummaries(PersonalAccessTokenSummary ... var1);

        public Builder personalAccessTokenSummaries(Consumer<PersonalAccessTokenSummary.Builder> ... var1);
    }
}

