/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LanguageCodeType {
    AR("AR"),
    BG("BG"),
    BN("BN"),
    DA("DA"),
    DE("DE"),
    CS("CS"),
    EL("EL"),
    EN("EN"),
    ES("ES"),
    FA("FA"),
    FI("FI"),
    FR("FR"),
    HI("HI"),
    HU("HU"),
    ID("ID"),
    IT("IT"),
    JA("JA"),
    KO("KO"),
    LT("LT"),
    LV("LV"),
    NL("NL"),
    NO("NO"),
    PT("PT"),
    RO("RO"),
    RU("RU"),
    SV("SV"),
    SW("SW"),
    TH("TH"),
    TR("TR"),
    ZH("ZH"),
    DEFAULT("DEFAULT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LanguageCodeType> VALUE_MAP;
    private final String value;

    private LanguageCodeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LanguageCodeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LanguageCodeType> knownValues() {
        EnumSet<LanguageCodeType> knownValues = EnumSet.allOf(LanguageCodeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LanguageCodeType.class, LanguageCodeType::toString);
    }
}

