/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListReviewTemplatesResponse;

public class ListReviewTemplatesPublisher
implements SdkPublisher<ListReviewTemplatesResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListReviewTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReviewTemplatesPublisher(WellArchitectedAsyncClient client, ListReviewTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReviewTemplatesPublisher(WellArchitectedAsyncClient client, ListReviewTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReviewTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReviewTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListReviewTemplatesResponseFetcher
    implements AsyncPageFetcher<ListReviewTemplatesResponse> {
        private ListReviewTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListReviewTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReviewTemplatesResponse> nextPage(ListReviewTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListReviewTemplatesPublisher.this.client.listReviewTemplates(ListReviewTemplatesPublisher.this.firstRequest);
            }
            return ListReviewTemplatesPublisher.this.client.listReviewTemplates((ListReviewTemplatesRequest)((Object)ListReviewTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

