/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.Question;
import software.amazon.awssdk.services.wellarchitected.model.QuestionCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReviewTemplatePillarReviewSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReviewTemplatePillarReviewSummary> {
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarId").getter(ReviewTemplatePillarReviewSummary.getter(ReviewTemplatePillarReviewSummary::pillarId)).setter(ReviewTemplatePillarReviewSummary.setter(Builder::pillarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()}).build();
    private static final SdkField<String> PILLAR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarName").getter(ReviewTemplatePillarReviewSummary.getter(ReviewTemplatePillarReviewSummary::pillarName)).setter(ReviewTemplatePillarReviewSummary.setter(Builder::pillarName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarName").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(ReviewTemplatePillarReviewSummary.getter(ReviewTemplatePillarReviewSummary::notes)).setter(ReviewTemplatePillarReviewSummary.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<Map<String, Integer>> QUESTION_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("QuestionCounts").getter(ReviewTemplatePillarReviewSummary.getter(ReviewTemplatePillarReviewSummary::questionCountsAsStrings)).setter(ReviewTemplatePillarReviewSummary.setter(Builder::questionCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PILLAR_ID_FIELD, PILLAR_NAME_FIELD, NOTES_FIELD, QUESTION_COUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PillarId", PILLAR_ID_FIELD);
            this.put("PillarName", PILLAR_NAME_FIELD);
            this.put("Notes", NOTES_FIELD);
            this.put("QuestionCounts", QUESTION_COUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String pillarId;
    private final String pillarName;
    private final String notes;
    private final Map<String, Integer> questionCounts;

    private ReviewTemplatePillarReviewSummary(BuilderImpl builder) {
        this.pillarId = builder.pillarId;
        this.pillarName = builder.pillarName;
        this.notes = builder.notes;
        this.questionCounts = builder.questionCounts;
    }

    public final String pillarId() {
        return this.pillarId;
    }

    public final String pillarName() {
        return this.pillarName;
    }

    public final String notes() {
        return this.notes;
    }

    public final Map<Question, Integer> questionCounts() {
        return QuestionCountsCopier.copyStringToEnum(this.questionCounts);
    }

    public final boolean hasQuestionCounts() {
        return this.questionCounts != null && !(this.questionCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> questionCountsAsStrings() {
        return this.questionCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuestionCounts() ? this.questionCountsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewTemplatePillarReviewSummary)) {
            return false;
        }
        ReviewTemplatePillarReviewSummary other = (ReviewTemplatePillarReviewSummary)obj;
        return Objects.equals(this.pillarId(), other.pillarId()) && Objects.equals(this.pillarName(), other.pillarName()) && Objects.equals(this.notes(), other.notes()) && this.hasQuestionCounts() == other.hasQuestionCounts() && Objects.equals(this.questionCountsAsStrings(), other.questionCountsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ReviewTemplatePillarReviewSummary").add("PillarId", (Object)this.pillarId()).add("PillarName", (Object)this.pillarName()).add("Notes", (Object)this.notes()).add("QuestionCounts", this.hasQuestionCounts() ? this.questionCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PillarId": {
                return Optional.ofNullable(clazz.cast(this.pillarId()));
            }
            case "PillarName": {
                return Optional.ofNullable(clazz.cast(this.pillarName()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "QuestionCounts": {
                return Optional.ofNullable(clazz.cast(this.questionCountsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReviewTemplatePillarReviewSummary, T> g) {
        return obj -> g.apply((ReviewTemplatePillarReviewSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pillarId;
        private String pillarName;
        private String notes;
        private Map<String, Integer> questionCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewTemplatePillarReviewSummary model) {
            this.pillarId(model.pillarId);
            this.pillarName(model.pillarName);
            this.notes(model.notes);
            this.questionCountsWithStrings(model.questionCounts);
        }

        public final String getPillarId() {
            return this.pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getPillarName() {
            return this.pillarName;
        }

        public final void setPillarName(String pillarName) {
            this.pillarName = pillarName;
        }

        @Override
        public final Builder pillarName(String pillarName) {
            this.pillarName = pillarName;
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Map<String, Integer> getQuestionCounts() {
            if (this.questionCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.questionCounts;
        }

        public final void setQuestionCounts(Map<String, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copy(questionCounts);
        }

        @Override
        public final Builder questionCountsWithStrings(Map<String, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copy(questionCounts);
            return this;
        }

        @Override
        public final Builder questionCounts(Map<Question, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copyEnumToString(questionCounts);
            return this;
        }

        public ReviewTemplatePillarReviewSummary build() {
            return new ReviewTemplatePillarReviewSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReviewTemplatePillarReviewSummary> {
        public Builder pillarId(String var1);

        public Builder pillarName(String var1);

        public Builder notes(String var1);

        public Builder questionCountsWithStrings(Map<String, Integer> var1);

        public Builder questionCounts(Map<Question, Integer> var1);
    }
}

