/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ProfileSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.ProfileSummary;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProfilesResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListProfilesResponse> {
    private static final SdkField<List<ProfileSummary>> PROFILE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileSummaries").getter(ListProfilesResponse.getter(ListProfilesResponse::profileSummaries)).setter(ListProfilesResponse.setter(Builder::profileSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProfilesResponse.getter(ListProfilesResponse::nextToken)).setter(ListProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProfileSummaries", PROFILE_SUMMARIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ProfileSummary> profileSummaries;
    private final String nextToken;

    private ListProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.profileSummaries = builder.profileSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProfileSummaries() {
        return this.profileSummaries != null && !(this.profileSummaries instanceof SdkAutoConstructList);
    }

    public final List<ProfileSummary> profileSummaries() {
        return this.profileSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileSummaries() ? this.profileSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilesResponse)) {
            return false;
        }
        ListProfilesResponse other = (ListProfilesResponse)((Object)obj);
        return this.hasProfileSummaries() == other.hasProfileSummaries() && Objects.equals(this.profileSummaries(), other.profileSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProfilesResponse").add("ProfileSummaries", this.hasProfileSummaries() ? this.profileSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileSummaries": {
                return Optional.ofNullable(clazz.cast(this.profileSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListProfilesResponse, T> g) {
        return obj -> g.apply((ListProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private List<ProfileSummary> profileSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfilesResponse model) {
            super(model);
            this.profileSummaries(model.profileSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ProfileSummary.Builder> getProfileSummaries() {
            List<ProfileSummary.Builder> result = ProfileSummariesCopier.copyToBuilder(this.profileSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileSummaries(Collection<ProfileSummary.BuilderImpl> profileSummaries) {
            this.profileSummaries = ProfileSummariesCopier.copyFromBuilder(profileSummaries);
        }

        @Override
        public final Builder profileSummaries(Collection<ProfileSummary> profileSummaries) {
            this.profileSummaries = ProfileSummariesCopier.copy(profileSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileSummaries(ProfileSummary ... profileSummaries) {
            this.profileSummaries(Arrays.asList(profileSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileSummaries(Consumer<ProfileSummary.Builder> ... profileSummaries) {
            this.profileSummaries(Stream.of(profileSummaries).map(c -> (ProfileSummary)((ProfileSummary.Builder)ProfileSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProfilesResponse build() {
            return new ListProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProfilesResponse> {
        public Builder profileSummaries(Collection<ProfileSummary> var1);

        public Builder profileSummaries(ProfileSummary ... var1);

        public Builder profileSummaries(Consumer<ProfileSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

