/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupSummariesCopier;
import software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupSummary;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAvailableManagedRuleGroupsResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, ListAvailableManagedRuleGroupsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListAvailableManagedRuleGroupsResponse.getter(ListAvailableManagedRuleGroupsResponse::nextMarker)).setter(ListAvailableManagedRuleGroupsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<ManagedRuleGroupSummary>> MANAGED_RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ManagedRuleGroups").getter(ListAvailableManagedRuleGroupsResponse.getter(ListAvailableManagedRuleGroupsResponse::managedRuleGroups)).setter(ListAvailableManagedRuleGroupsResponse.setter(Builder::managedRuleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedRuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedRuleGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, MANAGED_RULE_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextMarker", NEXT_MARKER_FIELD);
            this.put("ManagedRuleGroups", MANAGED_RULE_GROUPS_FIELD);
        }
    });
    private final String nextMarker;
    private final List<ManagedRuleGroupSummary> managedRuleGroups;

    private ListAvailableManagedRuleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.managedRuleGroups = builder.managedRuleGroups;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasManagedRuleGroups() {
        return this.managedRuleGroups != null && !(this.managedRuleGroups instanceof SdkAutoConstructList);
    }

    public final List<ManagedRuleGroupSummary> managedRuleGroups() {
        return this.managedRuleGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedRuleGroups() ? this.managedRuleGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableManagedRuleGroupsResponse)) {
            return false;
        }
        ListAvailableManagedRuleGroupsResponse other = (ListAvailableManagedRuleGroupsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasManagedRuleGroups() == other.hasManagedRuleGroups() && Objects.equals(this.managedRuleGroups(), other.managedRuleGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ListAvailableManagedRuleGroupsResponse").add("NextMarker", (Object)this.nextMarker()).add("ManagedRuleGroups", this.hasManagedRuleGroups() ? this.managedRuleGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "ManagedRuleGroups": {
                return Optional.ofNullable(clazz.cast(this.managedRuleGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableManagedRuleGroupsResponse, T> g) {
        return obj -> g.apply((ListAvailableManagedRuleGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<ManagedRuleGroupSummary> managedRuleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableManagedRuleGroupsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.managedRuleGroups(model.managedRuleGroups);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<ManagedRuleGroupSummary.Builder> getManagedRuleGroups() {
            List<ManagedRuleGroupSummary.Builder> result = ManagedRuleGroupSummariesCopier.copyToBuilder(this.managedRuleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedRuleGroups(Collection<ManagedRuleGroupSummary.BuilderImpl> managedRuleGroups) {
            this.managedRuleGroups = ManagedRuleGroupSummariesCopier.copyFromBuilder(managedRuleGroups);
        }

        @Override
        public final Builder managedRuleGroups(Collection<ManagedRuleGroupSummary> managedRuleGroups) {
            this.managedRuleGroups = ManagedRuleGroupSummariesCopier.copy(managedRuleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedRuleGroups(ManagedRuleGroupSummary ... managedRuleGroups) {
            this.managedRuleGroups(Arrays.asList(managedRuleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedRuleGroups(Consumer<ManagedRuleGroupSummary.Builder> ... managedRuleGroups) {
            this.managedRuleGroups(Stream.of(managedRuleGroups).map(c -> (ManagedRuleGroupSummary)((ManagedRuleGroupSummary.Builder)ManagedRuleGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAvailableManagedRuleGroupsResponse build() {
            return new ListAvailableManagedRuleGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAvailableManagedRuleGroupsResponse> {
        public Builder nextMarker(String var1);

        public Builder managedRuleGroups(Collection<ManagedRuleGroupSummary> var1);

        public Builder managedRuleGroups(ManagedRuleGroupSummary ... var1);

        public Builder managedRuleGroups(Consumer<ManagedRuleGroupSummary.Builder> ... var1);
    }
}

