/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MigrationErrorType {
    ENTITY_NOT_SUPPORTED("ENTITY_NOT_SUPPORTED"),
    ENTITY_NOT_FOUND("ENTITY_NOT_FOUND"),
    S3_BUCKET_NO_PERMISSION("S3_BUCKET_NO_PERMISSION"),
    S3_BUCKET_NOT_ACCESSIBLE("S3_BUCKET_NOT_ACCESSIBLE"),
    S3_BUCKET_NOT_FOUND("S3_BUCKET_NOT_FOUND"),
    S3_BUCKET_INVALID_REGION("S3_BUCKET_INVALID_REGION"),
    S3_INTERNAL_ERROR("S3_INTERNAL_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MigrationErrorType> VALUE_MAP;
    private final String value;

    private MigrationErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MigrationErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MigrationErrorType> knownValues() {
        EnumSet<MigrationErrorType> knownValues = EnumSet.allOf(MigrationErrorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MigrationErrorType.class, MigrationErrorType::toString);
    }
}

