/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RateKey;
import software.amazon.awssdk.services.waf.model.Tag;
import software.amazon.awssdk.services.waf.model.TagListCopier;
import software.amazon.awssdk.services.waf.model.WafRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRateBasedRuleRequest
extends WafRequest
implements ToCopyableBuilder<Builder, CreateRateBasedRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateRateBasedRuleRequest.getter(CreateRateBasedRuleRequest::name)).setter(CreateRateBasedRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(CreateRateBasedRuleRequest.getter(CreateRateBasedRuleRequest::metricName)).setter(CreateRateBasedRuleRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> RATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RateKey").getter(CreateRateBasedRuleRequest.getter(CreateRateBasedRuleRequest::rateKeyAsString)).setter(CreateRateBasedRuleRequest.setter(Builder::rateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateKey").build()}).build();
    private static final SdkField<Long> RATE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RateLimit").getter(CreateRateBasedRuleRequest.getter(CreateRateBasedRuleRequest::rateLimit)).setter(CreateRateBasedRuleRequest.setter(Builder::rateLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateLimit").build()}).build();
    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeToken").getter(CreateRateBasedRuleRequest.getter(CreateRateBasedRuleRequest::changeToken)).setter(CreateRateBasedRuleRequest.setter(Builder::changeToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateRateBasedRuleRequest.getter(CreateRateBasedRuleRequest::tags)).setter(CreateRateBasedRuleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, METRIC_NAME_FIELD, RATE_KEY_FIELD, RATE_LIMIT_FIELD, CHANGE_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("MetricName", METRIC_NAME_FIELD);
            this.put("RateKey", RATE_KEY_FIELD);
            this.put("RateLimit", RATE_LIMIT_FIELD);
            this.put("ChangeToken", CHANGE_TOKEN_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String name;
    private final String metricName;
    private final String rateKey;
    private final Long rateLimit;
    private final String changeToken;
    private final List<Tag> tags;

    private CreateRateBasedRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.metricName = builder.metricName;
        this.rateKey = builder.rateKey;
        this.rateLimit = builder.rateLimit;
        this.changeToken = builder.changeToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final RateKey rateKey() {
        return RateKey.fromValue(this.rateKey);
    }

    public final String rateKeyAsString() {
        return this.rateKey;
    }

    public final Long rateLimit() {
        return this.rateLimit;
    }

    public final String changeToken() {
        return this.changeToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRateBasedRuleRequest)) {
            return false;
        }
        CreateRateBasedRuleRequest other = (CreateRateBasedRuleRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.rateKeyAsString(), other.rateKeyAsString()) && Objects.equals(this.rateLimit(), other.rateLimit()) && Objects.equals(this.changeToken(), other.changeToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRateBasedRuleRequest").add("Name", (Object)this.name()).add("MetricName", (Object)this.metricName()).add("RateKey", (Object)this.rateKeyAsString()).add("RateLimit", (Object)this.rateLimit()).add("ChangeToken", (Object)this.changeToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "RateKey": {
                return Optional.ofNullable(clazz.cast(this.rateKeyAsString()));
            }
            case "RateLimit": {
                return Optional.ofNullable(clazz.cast(this.rateLimit()));
            }
            case "ChangeToken": {
                return Optional.ofNullable(clazz.cast(this.changeToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateRateBasedRuleRequest, T> g) {
        return obj -> g.apply((CreateRateBasedRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WafRequest.BuilderImpl
    implements Builder {
        private String name;
        private String metricName;
        private String rateKey;
        private Long rateLimit;
        private String changeToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRateBasedRuleRequest model) {
            super(model);
            this.name(model.name);
            this.metricName(model.metricName);
            this.rateKey(model.rateKey);
            this.rateLimit(model.rateLimit);
            this.changeToken(model.changeToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getRateKey() {
            return this.rateKey;
        }

        public final void setRateKey(String rateKey) {
            this.rateKey = rateKey;
        }

        @Override
        public final Builder rateKey(String rateKey) {
            this.rateKey = rateKey;
            return this;
        }

        @Override
        public final Builder rateKey(RateKey rateKey) {
            this.rateKey(rateKey == null ? null : rateKey.toString());
            return this;
        }

        public final Long getRateLimit() {
            return this.rateLimit;
        }

        public final void setRateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        public final Builder rateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRateBasedRuleRequest build() {
            return new CreateRateBasedRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WafRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRateBasedRuleRequest> {
        public Builder name(String var1);

        public Builder metricName(String var1);

        public Builder rateKey(String var1);

        public Builder rateKey(RateKey var1);

        public Builder rateLimit(Long var1);

        public Builder changeToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

