/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.verifiedpermissions.model.StaticPolicyDefinitionItem;
import software.amazon.awssdk.services.verifiedpermissions.model.TemplateLinkedPolicyDefinitionItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyDefinitionItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyDefinitionItem> {
    private static final SdkField<StaticPolicyDefinitionItem> STATIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("static").getter(PolicyDefinitionItem.getter(PolicyDefinitionItem::staticValue)).setter(PolicyDefinitionItem.setter(Builder::staticValue)).constructor(StaticPolicyDefinitionItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("static").build()}).build();
    private static final SdkField<TemplateLinkedPolicyDefinitionItem> TEMPLATE_LINKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("templateLinked").getter(PolicyDefinitionItem.getter(PolicyDefinitionItem::templateLinked)).setter(PolicyDefinitionItem.setter(Builder::templateLinked)).constructor(TemplateLinkedPolicyDefinitionItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateLinked").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_FIELD, TEMPLATE_LINKED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("static", STATIC_FIELD);
            this.put("templateLinked", TEMPLATE_LINKED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final StaticPolicyDefinitionItem staticValue;
    private final TemplateLinkedPolicyDefinitionItem templateLinked;
    private final Type type;

    private PolicyDefinitionItem(BuilderImpl builder) {
        this.staticValue = builder.staticValue;
        this.templateLinked = builder.templateLinked;
        this.type = builder.type;
    }

    public final StaticPolicyDefinitionItem staticValue() {
        return this.staticValue;
    }

    public final TemplateLinkedPolicyDefinitionItem templateLinked() {
        return this.templateLinked;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.staticValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateLinked());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDefinitionItem)) {
            return false;
        }
        PolicyDefinitionItem other = (PolicyDefinitionItem)obj;
        return Objects.equals(this.staticValue(), other.staticValue()) && Objects.equals(this.templateLinked(), other.templateLinked());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyDefinitionItem").add("Static", (Object)this.staticValue()).add("TemplateLinked", (Object)this.templateLinked()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "static": {
                return Optional.ofNullable(clazz.cast(this.staticValue()));
            }
            case "templateLinked": {
                return Optional.ofNullable(clazz.cast(this.templateLinked()));
            }
        }
        return Optional.empty();
    }

    public static PolicyDefinitionItem fromStaticValue(StaticPolicyDefinitionItem staticValue) {
        return (PolicyDefinitionItem)PolicyDefinitionItem.builder().staticValue(staticValue).build();
    }

    public static PolicyDefinitionItem fromStaticValue(Consumer<StaticPolicyDefinitionItem.Builder> staticValue) {
        StaticPolicyDefinitionItem.Builder builder = StaticPolicyDefinitionItem.builder();
        staticValue.accept(builder);
        return PolicyDefinitionItem.fromStaticValue((StaticPolicyDefinitionItem)builder.build());
    }

    public static PolicyDefinitionItem fromTemplateLinked(TemplateLinkedPolicyDefinitionItem templateLinked) {
        return (PolicyDefinitionItem)PolicyDefinitionItem.builder().templateLinked(templateLinked).build();
    }

    public static PolicyDefinitionItem fromTemplateLinked(Consumer<TemplateLinkedPolicyDefinitionItem.Builder> templateLinked) {
        TemplateLinkedPolicyDefinitionItem.Builder builder = TemplateLinkedPolicyDefinitionItem.builder();
        templateLinked.accept(builder);
        return PolicyDefinitionItem.fromTemplateLinked((TemplateLinkedPolicyDefinitionItem)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PolicyDefinitionItem, T> g) {
        return obj -> g.apply((PolicyDefinitionItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        STATIC,
        TEMPLATE_LINKED,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private StaticPolicyDefinitionItem staticValue;
        private TemplateLinkedPolicyDefinitionItem templateLinked;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDefinitionItem model) {
            this.staticValue(model.staticValue);
            this.templateLinked(model.templateLinked);
        }

        public final StaticPolicyDefinitionItem.Builder getStaticValue() {
            return this.staticValue != null ? this.staticValue.toBuilder() : null;
        }

        public final void setStaticValue(StaticPolicyDefinitionItem.BuilderImpl staticValue) {
            StaticPolicyDefinitionItem oldValue = this.staticValue;
            this.staticValue = staticValue != null ? staticValue.build() : null;
            this.handleUnionValueChange(Type.STATIC, oldValue, this.staticValue);
        }

        @Override
        public final Builder staticValue(StaticPolicyDefinitionItem staticValue) {
            StaticPolicyDefinitionItem oldValue = this.staticValue;
            this.staticValue = staticValue;
            this.handleUnionValueChange(Type.STATIC, oldValue, this.staticValue);
            return this;
        }

        public final TemplateLinkedPolicyDefinitionItem.Builder getTemplateLinked() {
            return this.templateLinked != null ? this.templateLinked.toBuilder() : null;
        }

        public final void setTemplateLinked(TemplateLinkedPolicyDefinitionItem.BuilderImpl templateLinked) {
            TemplateLinkedPolicyDefinitionItem oldValue = this.templateLinked;
            this.templateLinked = templateLinked != null ? templateLinked.build() : null;
            this.handleUnionValueChange(Type.TEMPLATE_LINKED, oldValue, this.templateLinked);
        }

        @Override
        public final Builder templateLinked(TemplateLinkedPolicyDefinitionItem templateLinked) {
            TemplateLinkedPolicyDefinitionItem oldValue = this.templateLinked;
            this.templateLinked = templateLinked;
            this.handleUnionValueChange(Type.TEMPLATE_LINKED, oldValue, this.templateLinked);
            return this;
        }

        public PolicyDefinitionItem build() {
            return new PolicyDefinitionItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyDefinitionItem> {
        public Builder staticValue(StaticPolicyDefinitionItem var1);

        default public Builder staticValue(Consumer<StaticPolicyDefinitionItem.Builder> staticValue) {
            return this.staticValue((StaticPolicyDefinitionItem)((StaticPolicyDefinitionItem.Builder)StaticPolicyDefinitionItem.builder().applyMutation(staticValue)).build());
        }

        public Builder templateLinked(TemplateLinkedPolicyDefinitionItem var1);

        default public Builder templateLinked(Consumer<TemplateLinkedPolicyDefinitionItem.Builder> templateLinked) {
            return this.templateLinked((TemplateLinkedPolicyDefinitionItem)((TemplateLinkedPolicyDefinitionItem.Builder)TemplateLinkedPolicyDefinitionItem.builder().applyMutation(templateLinked)).build());
        }
    }
}

