/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUserResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, CreateUserResponse> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(CreateUserResponse.getter(CreateUserResponse::serverId)).setter(CreateUserResponse.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(CreateUserResponse.getter(CreateUserResponse::userName)).setter(CreateUserResponse.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD, USER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ServerId", SERVER_ID_FIELD);
            this.put("UserName", USER_NAME_FIELD);
        }
    });
    private final String serverId;
    private final String userName;

    private CreateUserResponse(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.userName = builder.userName;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final String userName() {
        return this.userName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserResponse)) {
            return false;
        }
        CreateUserResponse other = (CreateUserResponse)((Object)obj);
        return Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.userName(), other.userName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUserResponse").add("ServerId", (Object)this.serverId()).add("UserName", (Object)this.userName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserResponse, T> g) {
        return obj -> g.apply((CreateUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String serverId;
        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserResponse model) {
            super(model);
            this.serverId(model.serverId);
            this.userName(model.userName);
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @Override
        public CreateUserResponse build() {
            return new CreateUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUserResponse> {
        public Builder serverId(String var1);

        public Builder userName(String var1);
    }
}

