/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobStatus;
import software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSummariesCopier;
import software.amazon.awssdk.services.transcribe.model.CallAnalyticsJobSummary;
import software.amazon.awssdk.services.transcribe.model.TranscribeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCallAnalyticsJobsResponse
extends TranscribeResponse
implements ToCopyableBuilder<Builder, ListCallAnalyticsJobsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListCallAnalyticsJobsResponse.getter(ListCallAnalyticsJobsResponse::statusAsString)).setter(ListCallAnalyticsJobsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCallAnalyticsJobsResponse.getter(ListCallAnalyticsJobsResponse::nextToken)).setter(ListCallAnalyticsJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<CallAnalyticsJobSummary>> CALL_ANALYTICS_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CallAnalyticsJobSummaries").getter(ListCallAnalyticsJobsResponse.getter(ListCallAnalyticsJobsResponse::callAnalyticsJobSummaries)).setter(ListCallAnalyticsJobsResponse.setter(Builder::callAnalyticsJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CallAnalyticsJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, NEXT_TOKEN_FIELD, CALL_ANALYTICS_JOB_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("CallAnalyticsJobSummaries", CALL_ANALYTICS_JOB_SUMMARIES_FIELD);
        }
    });
    private final String status;
    private final String nextToken;
    private final List<CallAnalyticsJobSummary> callAnalyticsJobSummaries;

    private ListCallAnalyticsJobsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.callAnalyticsJobSummaries = builder.callAnalyticsJobSummaries;
    }

    public final CallAnalyticsJobStatus status() {
        return CallAnalyticsJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCallAnalyticsJobSummaries() {
        return this.callAnalyticsJobSummaries != null && !(this.callAnalyticsJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<CallAnalyticsJobSummary> callAnalyticsJobSummaries() {
        return this.callAnalyticsJobSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCallAnalyticsJobSummaries() ? this.callAnalyticsJobSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCallAnalyticsJobsResponse)) {
            return false;
        }
        ListCallAnalyticsJobsResponse other = (ListCallAnalyticsJobsResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasCallAnalyticsJobSummaries() == other.hasCallAnalyticsJobSummaries() && Objects.equals(this.callAnalyticsJobSummaries(), other.callAnalyticsJobSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListCallAnalyticsJobsResponse").add("Status", (Object)this.statusAsString()).add("NextToken", (Object)this.nextToken()).add("CallAnalyticsJobSummaries", this.hasCallAnalyticsJobSummaries() ? this.callAnalyticsJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CallAnalyticsJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.callAnalyticsJobSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCallAnalyticsJobsResponse, T> g) {
        return obj -> g.apply((ListCallAnalyticsJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeResponse.BuilderImpl
    implements Builder {
        private String status;
        private String nextToken;
        private List<CallAnalyticsJobSummary> callAnalyticsJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCallAnalyticsJobsResponse model) {
            super(model);
            this.status(model.status);
            this.nextToken(model.nextToken);
            this.callAnalyticsJobSummaries(model.callAnalyticsJobSummaries);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CallAnalyticsJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CallAnalyticsJobSummary.Builder> getCallAnalyticsJobSummaries() {
            List<CallAnalyticsJobSummary.Builder> result = CallAnalyticsJobSummariesCopier.copyToBuilder(this.callAnalyticsJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCallAnalyticsJobSummaries(Collection<CallAnalyticsJobSummary.BuilderImpl> callAnalyticsJobSummaries) {
            this.callAnalyticsJobSummaries = CallAnalyticsJobSummariesCopier.copyFromBuilder(callAnalyticsJobSummaries);
        }

        @Override
        public final Builder callAnalyticsJobSummaries(Collection<CallAnalyticsJobSummary> callAnalyticsJobSummaries) {
            this.callAnalyticsJobSummaries = CallAnalyticsJobSummariesCopier.copy(callAnalyticsJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callAnalyticsJobSummaries(CallAnalyticsJobSummary ... callAnalyticsJobSummaries) {
            this.callAnalyticsJobSummaries(Arrays.asList(callAnalyticsJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callAnalyticsJobSummaries(Consumer<CallAnalyticsJobSummary.Builder> ... callAnalyticsJobSummaries) {
            this.callAnalyticsJobSummaries(Stream.of(callAnalyticsJobSummaries).map(c -> (CallAnalyticsJobSummary)((CallAnalyticsJobSummary.Builder)CallAnalyticsJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCallAnalyticsJobsResponse build() {
            return new ListCallAnalyticsJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TranscribeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCallAnalyticsJobsResponse> {
        public Builder status(String var1);

        public Builder status(CallAnalyticsJobStatus var1);

        public Builder nextToken(String var1);

        public Builder callAnalyticsJobSummaries(Collection<CallAnalyticsJobSummary> var1);

        public Builder callAnalyticsJobSummaries(CallAnalyticsJobSummary ... var1);

        public Builder callAnalyticsJobSummaries(Consumer<CallAnalyticsJobSummary.Builder> ... var1);
    }
}

