/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.sso.DefaultSsoAsyncClientBuilder;
import software.amazon.awssdk.services.sso.SsoAsyncClientBuilder;
import software.amazon.awssdk.services.sso.SsoServiceClientConfiguration;
import software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest;
import software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse;
import software.amazon.awssdk.services.sso.model.ListAccountRolesRequest;
import software.amazon.awssdk.services.sso.model.ListAccountRolesResponse;
import software.amazon.awssdk.services.sso.model.ListAccountsRequest;
import software.amazon.awssdk.services.sso.model.ListAccountsResponse;
import software.amazon.awssdk.services.sso.model.LogoutRequest;
import software.amazon.awssdk.services.sso.model.LogoutResponse;
import software.amazon.awssdk.services.sso.paginators.ListAccountRolesPublisher;
import software.amazon.awssdk.services.sso.paginators.ListAccountsPublisher;

@SdkPublicApi
@ThreadSafe
public interface SsoAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "awsssoportal";
    public static final String SERVICE_METADATA_ID = "portal.sso";

    default public CompletableFuture<GetRoleCredentialsResponse> getRoleCredentials(GetRoleCredentialsRequest getRoleCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetRoleCredentialsResponse> getRoleCredentials(Consumer<GetRoleCredentialsRequest.Builder> getRoleCredentialsRequest) {
        return this.getRoleCredentials((GetRoleCredentialsRequest)((Object)((GetRoleCredentialsRequest.Builder)GetRoleCredentialsRequest.builder().applyMutation(getRoleCredentialsRequest)).build()));
    }

    default public CompletableFuture<ListAccountRolesResponse> listAccountRoles(ListAccountRolesRequest listAccountRolesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListAccountRolesResponse> listAccountRoles(Consumer<ListAccountRolesRequest.Builder> listAccountRolesRequest) {
        return this.listAccountRoles((ListAccountRolesRequest)((Object)((ListAccountRolesRequest.Builder)ListAccountRolesRequest.builder().applyMutation(listAccountRolesRequest)).build()));
    }

    default public ListAccountRolesPublisher listAccountRolesPaginator(ListAccountRolesRequest listAccountRolesRequest) {
        return new ListAccountRolesPublisher(this, listAccountRolesRequest);
    }

    default public ListAccountRolesPublisher listAccountRolesPaginator(Consumer<ListAccountRolesRequest.Builder> listAccountRolesRequest) {
        return this.listAccountRolesPaginator((ListAccountRolesRequest)((Object)((ListAccountRolesRequest.Builder)ListAccountRolesRequest.builder().applyMutation(listAccountRolesRequest)).build()));
    }

    default public CompletableFuture<ListAccountsResponse> listAccounts(ListAccountsRequest listAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListAccountsResponse> listAccounts(Consumer<ListAccountsRequest.Builder> listAccountsRequest) {
        return this.listAccounts((ListAccountsRequest)((Object)((ListAccountsRequest.Builder)ListAccountsRequest.builder().applyMutation(listAccountsRequest)).build()));
    }

    default public ListAccountsPublisher listAccountsPaginator(ListAccountsRequest listAccountsRequest) {
        return new ListAccountsPublisher(this, listAccountsRequest);
    }

    default public ListAccountsPublisher listAccountsPaginator(Consumer<ListAccountsRequest.Builder> listAccountsRequest) {
        return this.listAccountsPaginator((ListAccountsRequest)((Object)((ListAccountsRequest.Builder)ListAccountsRequest.builder().applyMutation(listAccountsRequest)).build()));
    }

    default public CompletableFuture<LogoutResponse> logout(LogoutRequest logoutRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<LogoutResponse> logout(Consumer<LogoutRequest.Builder> logoutRequest) {
        return this.logout((LogoutRequest)((Object)((LogoutRequest.Builder)LogoutRequest.builder().applyMutation(logoutRequest)).build()));
    }

    default public SsoServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static SsoAsyncClient create() {
        return (SsoAsyncClient)SsoAsyncClient.builder().build();
    }

    public static SsoAsyncClientBuilder builder() {
        return new DefaultSsoAsyncClientBuilder();
    }
}

