/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmsap.model.OperationEvent;
import software.amazon.awssdk.services.ssmsap.model.OperationEventListCopier;
import software.amazon.awssdk.services.ssmsap.model.SsmSapResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOperationEventsResponse
extends SsmSapResponse
implements ToCopyableBuilder<Builder, ListOperationEventsResponse> {
    private static final SdkField<List<OperationEvent>> OPERATION_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperationEvents").getter(ListOperationEventsResponse.getter(ListOperationEventsResponse::operationEvents)).setter(ListOperationEventsResponse.setter(Builder::operationEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OperationEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOperationEventsResponse.getter(ListOperationEventsResponse::nextToken)).setter(ListOperationEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OperationEvents", OPERATION_EVENTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<OperationEvent> operationEvents;
    private final String nextToken;

    private ListOperationEventsResponse(BuilderImpl builder) {
        super(builder);
        this.operationEvents = builder.operationEvents;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOperationEvents() {
        return this.operationEvents != null && !(this.operationEvents instanceof SdkAutoConstructList);
    }

    public final List<OperationEvent> operationEvents() {
        return this.operationEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationEvents() ? this.operationEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationEventsResponse)) {
            return false;
        }
        ListOperationEventsResponse other = (ListOperationEventsResponse)((Object)obj);
        return this.hasOperationEvents() == other.hasOperationEvents() && Objects.equals(this.operationEvents(), other.operationEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOperationEventsResponse").add("OperationEvents", this.hasOperationEvents() ? this.operationEvents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperationEvents": {
                return Optional.ofNullable(clazz.cast(this.operationEvents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListOperationEventsResponse, T> g) {
        return obj -> g.apply((ListOperationEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmSapResponse.BuilderImpl
    implements Builder {
        private List<OperationEvent> operationEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationEventsResponse model) {
            super(model);
            this.operationEvents(model.operationEvents);
            this.nextToken(model.nextToken);
        }

        public final List<OperationEvent.Builder> getOperationEvents() {
            List<OperationEvent.Builder> result = OperationEventListCopier.copyToBuilder(this.operationEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperationEvents(Collection<OperationEvent.BuilderImpl> operationEvents) {
            this.operationEvents = OperationEventListCopier.copyFromBuilder(operationEvents);
        }

        @Override
        public final Builder operationEvents(Collection<OperationEvent> operationEvents) {
            this.operationEvents = OperationEventListCopier.copy(operationEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationEvents(OperationEvent ... operationEvents) {
            this.operationEvents(Arrays.asList(operationEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationEvents(Consumer<OperationEvent.Builder> ... operationEvents) {
            this.operationEvents(Stream.of(operationEvents).map(c -> (OperationEvent)((OperationEvent.Builder)OperationEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOperationEventsResponse build() {
            return new ListOperationEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmSapResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOperationEventsResponse> {
        public Builder operationEvents(Collection<OperationEvent> var1);

        public Builder operationEvents(OperationEvent ... var1);

        public Builder operationEvents(Consumer<OperationEvent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

