/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMaintenanceWindowRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, UpdateMaintenanceWindowRequest> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WindowId").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::windowId)).setter(UpdateMaintenanceWindowRequest.setter(Builder::windowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::name)).setter(UpdateMaintenanceWindowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::description)).setter(UpdateMaintenanceWindowRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartDate").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::startDate)).setter(UpdateMaintenanceWindowRequest.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<String> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndDate").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::endDate)).setter(UpdateMaintenanceWindowRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schedule").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::schedule)).setter(UpdateMaintenanceWindowRequest.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> SCHEDULE_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleTimezone").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::scheduleTimezone)).setter(UpdateMaintenanceWindowRequest.setter(Builder::scheduleTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleTimezone").build()}).build();
    private static final SdkField<Integer> SCHEDULE_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScheduleOffset").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::scheduleOffset)).setter(UpdateMaintenanceWindowRequest.setter(Builder::scheduleOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleOffset").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::duration)).setter(UpdateMaintenanceWindowRequest.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Integer> CUTOFF_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Cutoff").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::cutoff)).setter(UpdateMaintenanceWindowRequest.setter(Builder::cutoff)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cutoff").build()}).build();
    private static final SdkField<Boolean> ALLOW_UNASSOCIATED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowUnassociatedTargets").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::allowUnassociatedTargets)).setter(UpdateMaintenanceWindowRequest.setter(Builder::allowUnassociatedTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUnassociatedTargets").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::enabled)).setter(UpdateMaintenanceWindowRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Boolean> REPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Replace").getter(UpdateMaintenanceWindowRequest.getter(UpdateMaintenanceWindowRequest::replace)).setter(UpdateMaintenanceWindowRequest.setter(Builder::replace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, START_DATE_FIELD, END_DATE_FIELD, SCHEDULE_FIELD, SCHEDULE_TIMEZONE_FIELD, SCHEDULE_OFFSET_FIELD, DURATION_FIELD, CUTOFF_FIELD, ALLOW_UNASSOCIATED_TARGETS_FIELD, ENABLED_FIELD, REPLACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WindowId", WINDOW_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("StartDate", START_DATE_FIELD);
            this.put("EndDate", END_DATE_FIELD);
            this.put("Schedule", SCHEDULE_FIELD);
            this.put("ScheduleTimezone", SCHEDULE_TIMEZONE_FIELD);
            this.put("ScheduleOffset", SCHEDULE_OFFSET_FIELD);
            this.put("Duration", DURATION_FIELD);
            this.put("Cutoff", CUTOFF_FIELD);
            this.put("AllowUnassociatedTargets", ALLOW_UNASSOCIATED_TARGETS_FIELD);
            this.put("Enabled", ENABLED_FIELD);
            this.put("Replace", REPLACE_FIELD);
        }
    });
    private final String windowId;
    private final String name;
    private final String description;
    private final String startDate;
    private final String endDate;
    private final String schedule;
    private final String scheduleTimezone;
    private final Integer scheduleOffset;
    private final Integer duration;
    private final Integer cutoff;
    private final Boolean allowUnassociatedTargets;
    private final Boolean enabled;
    private final Boolean replace;

    private UpdateMaintenanceWindowRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.description = builder.description;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.schedule = builder.schedule;
        this.scheduleTimezone = builder.scheduleTimezone;
        this.scheduleOffset = builder.scheduleOffset;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.allowUnassociatedTargets = builder.allowUnassociatedTargets;
        this.enabled = builder.enabled;
        this.replace = builder.replace;
    }

    public final String windowId() {
        return this.windowId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String startDate() {
        return this.startDate;
    }

    public final String endDate() {
        return this.endDate;
    }

    public final String schedule() {
        return this.schedule;
    }

    public final String scheduleTimezone() {
        return this.scheduleTimezone;
    }

    public final Integer scheduleOffset() {
        return this.scheduleOffset;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Integer cutoff() {
        return this.cutoff;
    }

    public final Boolean allowUnassociatedTargets() {
        return this.allowUnassociatedTargets;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Boolean replace() {
        return this.replace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cutoff());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowUnassociatedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.replace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaintenanceWindowRequest)) {
            return false;
        }
        UpdateMaintenanceWindowRequest other = (UpdateMaintenanceWindowRequest)((Object)obj);
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.scheduleTimezone(), other.scheduleTimezone()) && Objects.equals(this.scheduleOffset(), other.scheduleOffset()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.cutoff(), other.cutoff()) && Objects.equals(this.allowUnassociatedTargets(), other.allowUnassociatedTargets()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.replace(), other.replace());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMaintenanceWindowRequest").add("WindowId", (Object)this.windowId()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("Schedule", (Object)this.schedule()).add("ScheduleTimezone", (Object)this.scheduleTimezone()).add("ScheduleOffset", (Object)this.scheduleOffset()).add("Duration", (Object)this.duration()).add("Cutoff", (Object)this.cutoff()).add("AllowUnassociatedTargets", (Object)this.allowUnassociatedTargets()).add("Enabled", (Object)this.enabled()).add("Replace", (Object)this.replace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "ScheduleTimezone": {
                return Optional.ofNullable(clazz.cast(this.scheduleTimezone()));
            }
            case "ScheduleOffset": {
                return Optional.ofNullable(clazz.cast(this.scheduleOffset()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Cutoff": {
                return Optional.ofNullable(clazz.cast(this.cutoff()));
            }
            case "AllowUnassociatedTargets": {
                return Optional.ofNullable(clazz.cast(this.allowUnassociatedTargets()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Replace": {
                return Optional.ofNullable(clazz.cast(this.replace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMaintenanceWindowRequest, T> g) {
        return obj -> g.apply((UpdateMaintenanceWindowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String windowId;
        private String name;
        private String description;
        private String startDate;
        private String endDate;
        private String schedule;
        private String scheduleTimezone;
        private Integer scheduleOffset;
        private Integer duration;
        private Integer cutoff;
        private Boolean allowUnassociatedTargets;
        private Boolean enabled;
        private Boolean replace;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaintenanceWindowRequest model) {
            super(model);
            this.windowId(model.windowId);
            this.name(model.name);
            this.description(model.description);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.schedule(model.schedule);
            this.scheduleTimezone(model.scheduleTimezone);
            this.scheduleOffset(model.scheduleOffset);
            this.duration(model.duration);
            this.cutoff(model.cutoff);
            this.allowUnassociatedTargets(model.allowUnassociatedTargets);
            this.enabled(model.enabled);
            this.replace(model.replace);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getScheduleTimezone() {
            return this.scheduleTimezone;
        }

        public final void setScheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
        }

        @Override
        public final Builder scheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
            return this;
        }

        public final Integer getScheduleOffset() {
            return this.scheduleOffset;
        }

        public final void setScheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        @Override
        public final Builder scheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Integer getCutoff() {
            return this.cutoff;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final Boolean getAllowUnassociatedTargets() {
            return this.allowUnassociatedTargets;
        }

        public final void setAllowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
        }

        @Override
        public final Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Boolean getReplace() {
            return this.replace;
        }

        public final void setReplace(Boolean replace) {
            this.replace = replace;
        }

        @Override
        public final Builder replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMaintenanceWindowRequest build() {
            return new UpdateMaintenanceWindowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMaintenanceWindowRequest> {
        public Builder windowId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder startDate(String var1);

        public Builder endDate(String var1);

        public Builder schedule(String var1);

        public Builder scheduleTimezone(String var1);

        public Builder scheduleOffset(Integer var1);

        public Builder duration(Integer var1);

        public Builder cutoff(Integer var1);

        public Builder allowUnassociatedTargets(Boolean var1);

        public Builder enabled(Boolean var1);

        public Builder replace(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

