/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.shield.model.ProtectionGroup;
import software.amazon.awssdk.services.shield.model.ProtectionGroupsCopier;
import software.amazon.awssdk.services.shield.model.ShieldResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProtectionGroupsResponse
extends ShieldResponse
implements ToCopyableBuilder<Builder, ListProtectionGroupsResponse> {
    private static final SdkField<List<ProtectionGroup>> PROTECTION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProtectionGroups").getter(ListProtectionGroupsResponse.getter(ListProtectionGroupsResponse::protectionGroups)).setter(ListProtectionGroupsResponse.setter(Builder::protectionGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtectionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProtectionGroupsResponse.getter(ListProtectionGroupsResponse::nextToken)).setter(ListProtectionGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProtectionGroups", PROTECTION_GROUPS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ProtectionGroup> protectionGroups;
    private final String nextToken;

    private ListProtectionGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.protectionGroups = builder.protectionGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProtectionGroups() {
        return this.protectionGroups != null && !(this.protectionGroups instanceof SdkAutoConstructList);
    }

    public final List<ProtectionGroup> protectionGroups() {
        return this.protectionGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtectionGroups() ? this.protectionGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectionGroupsResponse)) {
            return false;
        }
        ListProtectionGroupsResponse other = (ListProtectionGroupsResponse)((Object)obj);
        return this.hasProtectionGroups() == other.hasProtectionGroups() && Objects.equals(this.protectionGroups(), other.protectionGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProtectionGroupsResponse").add("ProtectionGroups", this.hasProtectionGroups() ? this.protectionGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectionGroups": {
                return Optional.ofNullable(clazz.cast(this.protectionGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListProtectionGroupsResponse, T> g) {
        return obj -> g.apply((ListProtectionGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ShieldResponse.BuilderImpl
    implements Builder {
        private List<ProtectionGroup> protectionGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtectionGroupsResponse model) {
            super(model);
            this.protectionGroups(model.protectionGroups);
            this.nextToken(model.nextToken);
        }

        public final List<ProtectionGroup.Builder> getProtectionGroups() {
            List<ProtectionGroup.Builder> result = ProtectionGroupsCopier.copyToBuilder(this.protectionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtectionGroups(Collection<ProtectionGroup.BuilderImpl> protectionGroups) {
            this.protectionGroups = ProtectionGroupsCopier.copyFromBuilder(protectionGroups);
        }

        @Override
        public final Builder protectionGroups(Collection<ProtectionGroup> protectionGroups) {
            this.protectionGroups = ProtectionGroupsCopier.copy(protectionGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectionGroups(ProtectionGroup ... protectionGroups) {
            this.protectionGroups(Arrays.asList(protectionGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectionGroups(Consumer<ProtectionGroup.Builder> ... protectionGroups) {
            this.protectionGroups(Stream.of(protectionGroups).map(c -> (ProtectionGroup)((ProtectionGroup.Builder)ProtectionGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProtectionGroupsResponse build() {
            return new ListProtectionGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ShieldResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProtectionGroupsResponse> {
        public Builder protectionGroups(Collection<ProtectionGroup> var1);

        public Builder protectionGroups(ProtectionGroup ... var1);

        public Builder protectionGroups(Consumer<ProtectionGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

