/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securitylake.SecurityLakeClient;
import software.amazon.awssdk.services.securitylake.internal.UserAgentUtils;
import software.amazon.awssdk.services.securitylake.model.DataLakeException;
import software.amazon.awssdk.services.securitylake.model.ListDataLakeExceptionsRequest;
import software.amazon.awssdk.services.securitylake.model.ListDataLakeExceptionsResponse;

public class ListDataLakeExceptionsIterable
implements SdkIterable<ListDataLakeExceptionsResponse> {
    private final SecurityLakeClient client;
    private final ListDataLakeExceptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataLakeExceptionsIterable(SecurityLakeClient client, ListDataLakeExceptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataLakeExceptionsResponseFetcher();
    }

    public Iterator<ListDataLakeExceptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataLakeException> exceptions() {
        Function<ListDataLakeExceptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.exceptions() != null) {
                return response.exceptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataLakeExceptionsResponseFetcher
    implements SyncPageFetcher<ListDataLakeExceptionsResponse> {
        private ListDataLakeExceptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataLakeExceptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataLakeExceptionsResponse nextPage(ListDataLakeExceptionsResponse previousPage) {
            if (previousPage == null) {
                return ListDataLakeExceptionsIterable.this.client.listDataLakeExceptions(ListDataLakeExceptionsIterable.this.firstRequest);
            }
            return ListDataLakeExceptionsIterable.this.client.listDataLakeExceptions((ListDataLakeExceptionsRequest)((Object)ListDataLakeExceptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

