/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsWafRulePredicateListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsWafRulePredicateListDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsWafRuleDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsWafRuleDetails> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(AwsWafRuleDetails.getter(AwsWafRuleDetails::metricName)).setter(AwsWafRuleDetails.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsWafRuleDetails.getter(AwsWafRuleDetails::name)).setter(AwsWafRuleDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<AwsWafRulePredicateListDetails>> PREDICATE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PredicateList").getter(AwsWafRuleDetails.getter(AwsWafRuleDetails::predicateList)).setter(AwsWafRuleDetails.setter(Builder::predicateList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredicateList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsWafRulePredicateListDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(AwsWafRuleDetails.getter(AwsWafRuleDetails::ruleId)).setter(AwsWafRuleDetails.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, NAME_FIELD, PREDICATE_LIST_FIELD, RULE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MetricName", METRIC_NAME_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("PredicateList", PREDICATE_LIST_FIELD);
            this.put("RuleId", RULE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String name;
    private final List<AwsWafRulePredicateListDetails> predicateList;
    private final String ruleId;

    private AwsWafRuleDetails(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.name = builder.name;
        this.predicateList = builder.predicateList;
        this.ruleId = builder.ruleId;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasPredicateList() {
        return this.predicateList != null && !(this.predicateList instanceof SdkAutoConstructList);
    }

    public final List<AwsWafRulePredicateListDetails> predicateList() {
        return this.predicateList;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredicateList() ? this.predicateList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafRuleDetails)) {
            return false;
        }
        AwsWafRuleDetails other = (AwsWafRuleDetails)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.name(), other.name()) && this.hasPredicateList() == other.hasPredicateList() && Objects.equals(this.predicateList(), other.predicateList()) && Objects.equals(this.ruleId(), other.ruleId());
    }

    public final String toString() {
        return ToString.builder((String)"AwsWafRuleDetails").add("MetricName", (Object)this.metricName()).add("Name", (Object)this.name()).add("PredicateList", this.hasPredicateList() ? this.predicateList() : null).add("RuleId", (Object)this.ruleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PredicateList": {
                return Optional.ofNullable(clazz.cast(this.predicateList()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafRuleDetails, T> g) {
        return obj -> g.apply((AwsWafRuleDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String name;
        private List<AwsWafRulePredicateListDetails> predicateList = DefaultSdkAutoConstructList.getInstance();
        private String ruleId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafRuleDetails model) {
            this.metricName(model.metricName);
            this.name(model.name);
            this.predicateList(model.predicateList);
            this.ruleId(model.ruleId);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AwsWafRulePredicateListDetails.Builder> getPredicateList() {
            List<AwsWafRulePredicateListDetails.Builder> result = AwsWafRulePredicateListCopier.copyToBuilder(this.predicateList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredicateList(Collection<AwsWafRulePredicateListDetails.BuilderImpl> predicateList) {
            this.predicateList = AwsWafRulePredicateListCopier.copyFromBuilder(predicateList);
        }

        @Override
        public final Builder predicateList(Collection<AwsWafRulePredicateListDetails> predicateList) {
            this.predicateList = AwsWafRulePredicateListCopier.copy(predicateList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicateList(AwsWafRulePredicateListDetails ... predicateList) {
            this.predicateList(Arrays.asList(predicateList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicateList(Consumer<AwsWafRulePredicateListDetails.Builder> ... predicateList) {
            this.predicateList(Stream.of(predicateList).map(c -> (AwsWafRulePredicateListDetails)((AwsWafRulePredicateListDetails.Builder)AwsWafRulePredicateListDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public AwsWafRuleDetails build() {
            return new AwsWafRuleDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsWafRuleDetails> {
        public Builder metricName(String var1);

        public Builder name(String var1);

        public Builder predicateList(Collection<AwsWafRulePredicateListDetails> var1);

        public Builder predicateList(AwsWafRulePredicateListDetails ... var1);

        public Builder predicateList(Consumer<AwsWafRulePredicateListDetails.Builder> ... var1);

        public Builder ruleId(String var1);
    }
}

