/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMonitoringAlertRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateMonitoringAlertRequest> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringScheduleName").getter(UpdateMonitoringAlertRequest.getter(UpdateMonitoringAlertRequest::monitoringScheduleName)).setter(UpdateMonitoringAlertRequest.setter(Builder::monitoringScheduleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build()}).build();
    private static final SdkField<String> MONITORING_ALERT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringAlertName").getter(UpdateMonitoringAlertRequest.getter(UpdateMonitoringAlertRequest::monitoringAlertName)).setter(UpdateMonitoringAlertRequest.setter(Builder::monitoringAlertName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAlertName").build()}).build();
    private static final SdkField<Integer> DATAPOINTS_TO_ALERT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DatapointsToAlert").getter(UpdateMonitoringAlertRequest.getter(UpdateMonitoringAlertRequest::datapointsToAlert)).setter(UpdateMonitoringAlertRequest.setter(Builder::datapointsToAlert)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatapointsToAlert").build()}).build();
    private static final SdkField<Integer> EVALUATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationPeriod").getter(UpdateMonitoringAlertRequest.getter(UpdateMonitoringAlertRequest::evaluationPeriod)).setter(UpdateMonitoringAlertRequest.setter(Builder::evaluationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_SCHEDULE_NAME_FIELD, MONITORING_ALERT_NAME_FIELD, DATAPOINTS_TO_ALERT_FIELD, EVALUATION_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MonitoringScheduleName", MONITORING_SCHEDULE_NAME_FIELD);
            this.put("MonitoringAlertName", MONITORING_ALERT_NAME_FIELD);
            this.put("DatapointsToAlert", DATAPOINTS_TO_ALERT_FIELD);
            this.put("EvaluationPeriod", EVALUATION_PERIOD_FIELD);
        }
    });
    private final String monitoringScheduleName;
    private final String monitoringAlertName;
    private final Integer datapointsToAlert;
    private final Integer evaluationPeriod;

    private UpdateMonitoringAlertRequest(BuilderImpl builder) {
        super(builder);
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringAlertName = builder.monitoringAlertName;
        this.datapointsToAlert = builder.datapointsToAlert;
        this.evaluationPeriod = builder.evaluationPeriod;
    }

    public final String monitoringScheduleName() {
        return this.monitoringScheduleName;
    }

    public final String monitoringAlertName() {
        return this.monitoringAlertName;
    }

    public final Integer datapointsToAlert() {
        return this.datapointsToAlert;
    }

    public final Integer evaluationPeriod() {
        return this.evaluationPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringAlertName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datapointsToAlert());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitoringAlertRequest)) {
            return false;
        }
        UpdateMonitoringAlertRequest other = (UpdateMonitoringAlertRequest)((Object)obj);
        return Objects.equals(this.monitoringScheduleName(), other.monitoringScheduleName()) && Objects.equals(this.monitoringAlertName(), other.monitoringAlertName()) && Objects.equals(this.datapointsToAlert(), other.datapointsToAlert()) && Objects.equals(this.evaluationPeriod(), other.evaluationPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMonitoringAlertRequest").add("MonitoringScheduleName", (Object)this.monitoringScheduleName()).add("MonitoringAlertName", (Object)this.monitoringAlertName()).add("DatapointsToAlert", (Object)this.datapointsToAlert()).add("EvaluationPeriod", (Object)this.evaluationPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringScheduleName": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleName()));
            }
            case "MonitoringAlertName": {
                return Optional.ofNullable(clazz.cast(this.monitoringAlertName()));
            }
            case "DatapointsToAlert": {
                return Optional.ofNullable(clazz.cast(this.datapointsToAlert()));
            }
            case "EvaluationPeriod": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitoringAlertRequest, T> g) {
        return obj -> g.apply((UpdateMonitoringAlertRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String monitoringScheduleName;
        private String monitoringAlertName;
        private Integer datapointsToAlert;
        private Integer evaluationPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitoringAlertRequest model) {
            super(model);
            this.monitoringScheduleName(model.monitoringScheduleName);
            this.monitoringAlertName(model.monitoringAlertName);
            this.datapointsToAlert(model.datapointsToAlert);
            this.evaluationPeriod(model.evaluationPeriod);
        }

        public final String getMonitoringScheduleName() {
            return this.monitoringScheduleName;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final String getMonitoringAlertName() {
            return this.monitoringAlertName;
        }

        public final void setMonitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
        }

        @Override
        public final Builder monitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
            return this;
        }

        public final Integer getDatapointsToAlert() {
            return this.datapointsToAlert;
        }

        public final void setDatapointsToAlert(Integer datapointsToAlert) {
            this.datapointsToAlert = datapointsToAlert;
        }

        @Override
        public final Builder datapointsToAlert(Integer datapointsToAlert) {
            this.datapointsToAlert = datapointsToAlert;
            return this;
        }

        public final Integer getEvaluationPeriod() {
            return this.evaluationPeriod;
        }

        public final void setEvaluationPeriod(Integer evaluationPeriod) {
            this.evaluationPeriod = evaluationPeriod;
        }

        @Override
        public final Builder evaluationPeriod(Integer evaluationPeriod) {
            this.evaluationPeriod = evaluationPeriod;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMonitoringAlertRequest build() {
            return new UpdateMonitoringAlertRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMonitoringAlertRequest> {
        public Builder monitoringScheduleName(String var1);

        public Builder monitoringAlertName(String var1);

        public Builder datapointsToAlert(Integer var1);

        public Builder evaluationPeriod(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

