/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ProcessingS3CompressionType;
import software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType;
import software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataType;
import software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcessingS3Input
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcessingS3Input> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(ProcessingS3Input.getter(ProcessingS3Input::s3Uri)).setter(ProcessingS3Input.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalPath").getter(ProcessingS3Input.getter(ProcessingS3Input::localPath)).setter(ProcessingS3Input.setter(Builder::localPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()}).build();
    private static final SdkField<String> S3_DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3DataType").getter(ProcessingS3Input.getter(ProcessingS3Input::s3DataTypeAsString)).setter(ProcessingS3Input.setter(Builder::s3DataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataType").build()}).build();
    private static final SdkField<String> S3_INPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3InputMode").getter(ProcessingS3Input.getter(ProcessingS3Input::s3InputModeAsString)).setter(ProcessingS3Input.setter(Builder::s3InputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InputMode").build()}).build();
    private static final SdkField<String> S3_DATA_DISTRIBUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3DataDistributionType").getter(ProcessingS3Input.getter(ProcessingS3Input::s3DataDistributionTypeAsString)).setter(ProcessingS3Input.setter(Builder::s3DataDistributionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataDistributionType").build()}).build();
    private static final SdkField<String> S3_COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3CompressionType").getter(ProcessingS3Input.getter(ProcessingS3Input::s3CompressionTypeAsString)).setter(ProcessingS3Input.setter(Builder::s3CompressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3CompressionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, LOCAL_PATH_FIELD, S3_DATA_TYPE_FIELD, S3_INPUT_MODE_FIELD, S3_DATA_DISTRIBUTION_TYPE_FIELD, S3_COMPRESSION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("S3Uri", S3_URI_FIELD);
            this.put("LocalPath", LOCAL_PATH_FIELD);
            this.put("S3DataType", S3_DATA_TYPE_FIELD);
            this.put("S3InputMode", S3_INPUT_MODE_FIELD);
            this.put("S3DataDistributionType", S3_DATA_DISTRIBUTION_TYPE_FIELD);
            this.put("S3CompressionType", S3_COMPRESSION_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final String localPath;
    private final String s3DataType;
    private final String s3InputMode;
    private final String s3DataDistributionType;
    private final String s3CompressionType;

    private ProcessingS3Input(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.localPath = builder.localPath;
        this.s3DataType = builder.s3DataType;
        this.s3InputMode = builder.s3InputMode;
        this.s3DataDistributionType = builder.s3DataDistributionType;
        this.s3CompressionType = builder.s3CompressionType;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final String localPath() {
        return this.localPath;
    }

    public final ProcessingS3DataType s3DataType() {
        return ProcessingS3DataType.fromValue(this.s3DataType);
    }

    public final String s3DataTypeAsString() {
        return this.s3DataType;
    }

    public final ProcessingS3InputMode s3InputMode() {
        return ProcessingS3InputMode.fromValue(this.s3InputMode);
    }

    public final String s3InputModeAsString() {
        return this.s3InputMode;
    }

    public final ProcessingS3DataDistributionType s3DataDistributionType() {
        return ProcessingS3DataDistributionType.fromValue(this.s3DataDistributionType);
    }

    public final String s3DataDistributionTypeAsString() {
        return this.s3DataDistributionType;
    }

    public final ProcessingS3CompressionType s3CompressionType() {
        return ProcessingS3CompressionType.fromValue(this.s3CompressionType);
    }

    public final String s3CompressionTypeAsString() {
        return this.s3CompressionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3InputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataDistributionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3CompressionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingS3Input)) {
            return false;
        }
        ProcessingS3Input other = (ProcessingS3Input)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.localPath(), other.localPath()) && Objects.equals(this.s3DataTypeAsString(), other.s3DataTypeAsString()) && Objects.equals(this.s3InputModeAsString(), other.s3InputModeAsString()) && Objects.equals(this.s3DataDistributionTypeAsString(), other.s3DataDistributionTypeAsString()) && Objects.equals(this.s3CompressionTypeAsString(), other.s3CompressionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProcessingS3Input").add("S3Uri", (Object)this.s3Uri()).add("LocalPath", (Object)this.localPath()).add("S3DataType", (Object)this.s3DataTypeAsString()).add("S3InputMode", (Object)this.s3InputModeAsString()).add("S3DataDistributionType", (Object)this.s3DataDistributionTypeAsString()).add("S3CompressionType", (Object)this.s3CompressionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "LocalPath": {
                return Optional.ofNullable(clazz.cast(this.localPath()));
            }
            case "S3DataType": {
                return Optional.ofNullable(clazz.cast(this.s3DataTypeAsString()));
            }
            case "S3InputMode": {
                return Optional.ofNullable(clazz.cast(this.s3InputModeAsString()));
            }
            case "S3DataDistributionType": {
                return Optional.ofNullable(clazz.cast(this.s3DataDistributionTypeAsString()));
            }
            case "S3CompressionType": {
                return Optional.ofNullable(clazz.cast(this.s3CompressionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingS3Input, T> g) {
        return obj -> g.apply((ProcessingS3Input)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String localPath;
        private String s3DataType;
        private String s3InputMode;
        private String s3DataDistributionType;
        private String s3CompressionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingS3Input model) {
            this.s3Uri(model.s3Uri);
            this.localPath(model.localPath);
            this.s3DataType(model.s3DataType);
            this.s3InputMode(model.s3InputMode);
            this.s3DataDistributionType(model.s3DataDistributionType);
            this.s3CompressionType(model.s3CompressionType);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getLocalPath() {
            return this.localPath;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final String getS3DataType() {
            return this.s3DataType;
        }

        public final void setS3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
        }

        @Override
        public final Builder s3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
            return this;
        }

        @Override
        public final Builder s3DataType(ProcessingS3DataType s3DataType) {
            this.s3DataType(s3DataType == null ? null : s3DataType.toString());
            return this;
        }

        public final String getS3InputMode() {
            return this.s3InputMode;
        }

        public final void setS3InputMode(String s3InputMode) {
            this.s3InputMode = s3InputMode;
        }

        @Override
        public final Builder s3InputMode(String s3InputMode) {
            this.s3InputMode = s3InputMode;
            return this;
        }

        @Override
        public final Builder s3InputMode(ProcessingS3InputMode s3InputMode) {
            this.s3InputMode(s3InputMode == null ? null : s3InputMode.toString());
            return this;
        }

        public final String getS3DataDistributionType() {
            return this.s3DataDistributionType;
        }

        public final void setS3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
        }

        @Override
        public final Builder s3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
            return this;
        }

        @Override
        public final Builder s3DataDistributionType(ProcessingS3DataDistributionType s3DataDistributionType) {
            this.s3DataDistributionType(s3DataDistributionType == null ? null : s3DataDistributionType.toString());
            return this;
        }

        public final String getS3CompressionType() {
            return this.s3CompressionType;
        }

        public final void setS3CompressionType(String s3CompressionType) {
            this.s3CompressionType = s3CompressionType;
        }

        @Override
        public final Builder s3CompressionType(String s3CompressionType) {
            this.s3CompressionType = s3CompressionType;
            return this;
        }

        @Override
        public final Builder s3CompressionType(ProcessingS3CompressionType s3CompressionType) {
            this.s3CompressionType(s3CompressionType == null ? null : s3CompressionType.toString());
            return this;
        }

        public ProcessingS3Input build() {
            return new ProcessingS3Input(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcessingS3Input> {
        public Builder s3Uri(String var1);

        public Builder localPath(String var1);

        public Builder s3DataType(String var1);

        public Builder s3DataType(ProcessingS3DataType var1);

        public Builder s3InputMode(String var1);

        public Builder s3InputMode(ProcessingS3InputMode var1);

        public Builder s3DataDistributionType(String var1);

        public Builder s3DataDistributionType(ProcessingS3DataDistributionType var1);

        public Builder s3CompressionType(String var1);

        public Builder s3CompressionType(ProcessingS3CompressionType var1);
    }
}

