/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition;
import software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationsCopier;
import software.amazon.awssdk.services.sagemaker.model.CustomerMetadataMapCopier;
import software.amazon.awssdk.services.sagemaker.model.DriftCheckBaselines;
import software.amazon.awssdk.services.sagemaker.model.InferenceSpecification;
import software.amazon.awssdk.services.sagemaker.model.MetadataProperties;
import software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus;
import software.amazon.awssdk.services.sagemaker.model.ModelLifeCycle;
import software.amazon.awssdk.services.sagemaker.model.ModelMetrics;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageModelCard;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageSecurityConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageStatusDetails;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationSpecification;
import software.amazon.awssdk.services.sagemaker.model.SkipModelValidation;
import software.amazon.awssdk.services.sagemaker.model.SourceAlgorithmSpecification;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelPackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelPackage> {
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageName").getter(ModelPackage.getter(ModelPackage::modelPackageName)).setter(ModelPackage.setter(Builder::modelPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupName").getter(ModelPackage.getter(ModelPackage::modelPackageGroupName)).setter(ModelPackage.setter(Builder::modelPackageGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build()}).build();
    private static final SdkField<Integer> MODEL_PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ModelPackageVersion").getter(ModelPackage.getter(ModelPackage::modelPackageVersion)).setter(ModelPackage.setter(Builder::modelPackageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersion").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageArn").getter(ModelPackage.getter(ModelPackage::modelPackageArn)).setter(ModelPackage.setter(Builder::modelPackageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageDescription").getter(ModelPackage.getter(ModelPackage::modelPackageDescription)).setter(ModelPackage.setter(Builder::modelPackageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ModelPackage.getter(ModelPackage::creationTime)).setter(ModelPackage.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceSpecification").getter(ModelPackage.getter(ModelPackage::inferenceSpecification)).setter(ModelPackage.setter(Builder::inferenceSpecification)).constructor(InferenceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build()}).build();
    private static final SdkField<SourceAlgorithmSpecification> SOURCE_ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceAlgorithmSpecification").getter(ModelPackage.getter(ModelPackage::sourceAlgorithmSpecification)).setter(ModelPackage.setter(Builder::sourceAlgorithmSpecification)).constructor(SourceAlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAlgorithmSpecification").build()}).build();
    private static final SdkField<ModelPackageValidationSpecification> VALIDATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidationSpecification").getter(ModelPackage.getter(ModelPackage::validationSpecification)).setter(ModelPackage.setter(Builder::validationSpecification)).constructor(ModelPackageValidationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSpecification").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageStatus").getter(ModelPackage.getter(ModelPackage::modelPackageStatusAsString)).setter(ModelPackage.setter(Builder::modelPackageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatus").build()}).build();
    private static final SdkField<ModelPackageStatusDetails> MODEL_PACKAGE_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelPackageStatusDetails").getter(ModelPackage.getter(ModelPackage::modelPackageStatusDetails)).setter(ModelPackage.setter(Builder::modelPackageStatusDetails)).constructor(ModelPackageStatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatusDetails").build()}).build();
    private static final SdkField<Boolean> CERTIFY_FOR_MARKETPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CertifyForMarketplace").getter(ModelPackage.getter(ModelPackage::certifyForMarketplace)).setter(ModelPackage.setter(Builder::certifyForMarketplace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertifyForMarketplace").build()}).build();
    private static final SdkField<String> MODEL_APPROVAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelApprovalStatus").getter(ModelPackage.getter(ModelPackage::modelApprovalStatusAsString)).setter(ModelPackage.setter(Builder::modelApprovalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelApprovalStatus").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(ModelPackage.getter(ModelPackage::createdBy)).setter(ModelPackage.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataProperties").getter(ModelPackage.getter(ModelPackage::metadataProperties)).setter(ModelPackage.setter(Builder::metadataProperties)).constructor(MetadataProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build()}).build();
    private static final SdkField<ModelMetrics> MODEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelMetrics").getter(ModelPackage.getter(ModelPackage::modelMetrics)).setter(ModelPackage.setter(Builder::modelMetrics)).constructor(ModelMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetrics").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ModelPackage.getter(ModelPackage::lastModifiedTime)).setter(ModelPackage.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(ModelPackage.getter(ModelPackage::lastModifiedBy)).setter(ModelPackage.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<String> APPROVAL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovalDescription").getter(ModelPackage.getter(ModelPackage::approvalDescription)).setter(ModelPackage.setter(Builder::approvalDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalDescription").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(ModelPackage.getter(ModelPackage::domain)).setter(ModelPackage.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Task").getter(ModelPackage.getter(ModelPackage::task)).setter(ModelPackage.setter(Builder::task)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Task").build()}).build();
    private static final SdkField<String> SAMPLE_PAYLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SamplePayloadUrl").getter(ModelPackage.getter(ModelPackage::samplePayloadUrl)).setter(ModelPackage.setter(Builder::samplePayloadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplePayloadUrl").build()}).build();
    private static final SdkField<List<AdditionalInferenceSpecificationDefinition>> ADDITIONAL_INFERENCE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalInferenceSpecifications").getter(ModelPackage.getter(ModelPackage::additionalInferenceSpecifications)).setter(ModelPackage.setter(Builder::additionalInferenceSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInferenceSpecifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalInferenceSpecificationDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceUri").getter(ModelPackage.getter(ModelPackage::sourceUri)).setter(ModelPackage.setter(Builder::sourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUri").build()}).build();
    private static final SdkField<ModelPackageSecurityConfig> SECURITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityConfig").getter(ModelPackage.getter(ModelPackage::securityConfig)).setter(ModelPackage.setter(Builder::securityConfig)).constructor(ModelPackageSecurityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()}).build();
    private static final SdkField<ModelPackageModelCard> MODEL_CARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelCard").getter(ModelPackage.getter(ModelPackage::modelCard)).setter(ModelPackage.setter(Builder::modelCard)).constructor(ModelPackageModelCard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCard").build()}).build();
    private static final SdkField<ModelLifeCycle> MODEL_LIFE_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelLifeCycle").getter(ModelPackage.getter(ModelPackage::modelLifeCycle)).setter(ModelPackage.setter(Builder::modelLifeCycle)).constructor(ModelLifeCycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelLifeCycle").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ModelPackage.getter(ModelPackage::tags)).setter(ModelPackage.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CUSTOMER_METADATA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomerMetadataProperties").getter(ModelPackage.getter(ModelPackage::customerMetadataProperties)).setter(ModelPackage.setter(Builder::customerMetadataProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMetadataProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DriftCheckBaselines> DRIFT_CHECK_BASELINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DriftCheckBaselines").getter(ModelPackage.getter(ModelPackage::driftCheckBaselines)).setter(ModelPackage.setter(Builder::driftCheckBaselines)).constructor(DriftCheckBaselines::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftCheckBaselines").build()}).build();
    private static final SdkField<String> SKIP_MODEL_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SkipModelValidation").getter(ModelPackage.getter(ModelPackage::skipModelValidationAsString)).setter(ModelPackage.setter(Builder::skipModelValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipModelValidation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_NAME_FIELD, MODEL_PACKAGE_GROUP_NAME_FIELD, MODEL_PACKAGE_VERSION_FIELD, MODEL_PACKAGE_ARN_FIELD, MODEL_PACKAGE_DESCRIPTION_FIELD, CREATION_TIME_FIELD, INFERENCE_SPECIFICATION_FIELD, SOURCE_ALGORITHM_SPECIFICATION_FIELD, VALIDATION_SPECIFICATION_FIELD, MODEL_PACKAGE_STATUS_FIELD, MODEL_PACKAGE_STATUS_DETAILS_FIELD, CERTIFY_FOR_MARKETPLACE_FIELD, MODEL_APPROVAL_STATUS_FIELD, CREATED_BY_FIELD, METADATA_PROPERTIES_FIELD, MODEL_METRICS_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, APPROVAL_DESCRIPTION_FIELD, DOMAIN_FIELD, TASK_FIELD, SAMPLE_PAYLOAD_URL_FIELD, ADDITIONAL_INFERENCE_SPECIFICATIONS_FIELD, SOURCE_URI_FIELD, SECURITY_CONFIG_FIELD, MODEL_CARD_FIELD, MODEL_LIFE_CYCLE_FIELD, TAGS_FIELD, CUSTOMER_METADATA_PROPERTIES_FIELD, DRIFT_CHECK_BASELINES_FIELD, SKIP_MODEL_VALIDATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ModelPackageName", MODEL_PACKAGE_NAME_FIELD);
            this.put("ModelPackageGroupName", MODEL_PACKAGE_GROUP_NAME_FIELD);
            this.put("ModelPackageVersion", MODEL_PACKAGE_VERSION_FIELD);
            this.put("ModelPackageArn", MODEL_PACKAGE_ARN_FIELD);
            this.put("ModelPackageDescription", MODEL_PACKAGE_DESCRIPTION_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("InferenceSpecification", INFERENCE_SPECIFICATION_FIELD);
            this.put("SourceAlgorithmSpecification", SOURCE_ALGORITHM_SPECIFICATION_FIELD);
            this.put("ValidationSpecification", VALIDATION_SPECIFICATION_FIELD);
            this.put("ModelPackageStatus", MODEL_PACKAGE_STATUS_FIELD);
            this.put("ModelPackageStatusDetails", MODEL_PACKAGE_STATUS_DETAILS_FIELD);
            this.put("CertifyForMarketplace", CERTIFY_FOR_MARKETPLACE_FIELD);
            this.put("ModelApprovalStatus", MODEL_APPROVAL_STATUS_FIELD);
            this.put("CreatedBy", CREATED_BY_FIELD);
            this.put("MetadataProperties", METADATA_PROPERTIES_FIELD);
            this.put("ModelMetrics", MODEL_METRICS_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
            this.put("ApprovalDescription", APPROVAL_DESCRIPTION_FIELD);
            this.put("Domain", DOMAIN_FIELD);
            this.put("Task", TASK_FIELD);
            this.put("SamplePayloadUrl", SAMPLE_PAYLOAD_URL_FIELD);
            this.put("AdditionalInferenceSpecifications", ADDITIONAL_INFERENCE_SPECIFICATIONS_FIELD);
            this.put("SourceUri", SOURCE_URI_FIELD);
            this.put("SecurityConfig", SECURITY_CONFIG_FIELD);
            this.put("ModelCard", MODEL_CARD_FIELD);
            this.put("ModelLifeCycle", MODEL_LIFE_CYCLE_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("CustomerMetadataProperties", CUSTOMER_METADATA_PROPERTIES_FIELD);
            this.put("DriftCheckBaselines", DRIFT_CHECK_BASELINES_FIELD);
            this.put("SkipModelValidation", SKIP_MODEL_VALIDATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String modelPackageName;
    private final String modelPackageGroupName;
    private final Integer modelPackageVersion;
    private final String modelPackageArn;
    private final String modelPackageDescription;
    private final Instant creationTime;
    private final InferenceSpecification inferenceSpecification;
    private final SourceAlgorithmSpecification sourceAlgorithmSpecification;
    private final ModelPackageValidationSpecification validationSpecification;
    private final String modelPackageStatus;
    private final ModelPackageStatusDetails modelPackageStatusDetails;
    private final Boolean certifyForMarketplace;
    private final String modelApprovalStatus;
    private final UserContext createdBy;
    private final MetadataProperties metadataProperties;
    private final ModelMetrics modelMetrics;
    private final Instant lastModifiedTime;
    private final UserContext lastModifiedBy;
    private final String approvalDescription;
    private final String domain;
    private final String task;
    private final String samplePayloadUrl;
    private final List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications;
    private final String sourceUri;
    private final ModelPackageSecurityConfig securityConfig;
    private final ModelPackageModelCard modelCard;
    private final ModelLifeCycle modelLifeCycle;
    private final List<Tag> tags;
    private final Map<String, String> customerMetadataProperties;
    private final DriftCheckBaselines driftCheckBaselines;
    private final String skipModelValidation;

    private ModelPackage(BuilderImpl builder) {
        this.modelPackageName = builder.modelPackageName;
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.modelPackageVersion = builder.modelPackageVersion;
        this.modelPackageArn = builder.modelPackageArn;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.creationTime = builder.creationTime;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.sourceAlgorithmSpecification = builder.sourceAlgorithmSpecification;
        this.validationSpecification = builder.validationSpecification;
        this.modelPackageStatus = builder.modelPackageStatus;
        this.modelPackageStatusDetails = builder.modelPackageStatusDetails;
        this.certifyForMarketplace = builder.certifyForMarketplace;
        this.modelApprovalStatus = builder.modelApprovalStatus;
        this.createdBy = builder.createdBy;
        this.metadataProperties = builder.metadataProperties;
        this.modelMetrics = builder.modelMetrics;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.approvalDescription = builder.approvalDescription;
        this.domain = builder.domain;
        this.task = builder.task;
        this.samplePayloadUrl = builder.samplePayloadUrl;
        this.additionalInferenceSpecifications = builder.additionalInferenceSpecifications;
        this.sourceUri = builder.sourceUri;
        this.securityConfig = builder.securityConfig;
        this.modelCard = builder.modelCard;
        this.modelLifeCycle = builder.modelLifeCycle;
        this.tags = builder.tags;
        this.customerMetadataProperties = builder.customerMetadataProperties;
        this.driftCheckBaselines = builder.driftCheckBaselines;
        this.skipModelValidation = builder.skipModelValidation;
    }

    public final String modelPackageName() {
        return this.modelPackageName;
    }

    public final String modelPackageGroupName() {
        return this.modelPackageGroupName;
    }

    public final Integer modelPackageVersion() {
        return this.modelPackageVersion;
    }

    public final String modelPackageArn() {
        return this.modelPackageArn;
    }

    public final String modelPackageDescription() {
        return this.modelPackageDescription;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final InferenceSpecification inferenceSpecification() {
        return this.inferenceSpecification;
    }

    public final SourceAlgorithmSpecification sourceAlgorithmSpecification() {
        return this.sourceAlgorithmSpecification;
    }

    public final ModelPackageValidationSpecification validationSpecification() {
        return this.validationSpecification;
    }

    public final ModelPackageStatus modelPackageStatus() {
        return ModelPackageStatus.fromValue(this.modelPackageStatus);
    }

    public final String modelPackageStatusAsString() {
        return this.modelPackageStatus;
    }

    public final ModelPackageStatusDetails modelPackageStatusDetails() {
        return this.modelPackageStatusDetails;
    }

    public final Boolean certifyForMarketplace() {
        return this.certifyForMarketplace;
    }

    public final ModelApprovalStatus modelApprovalStatus() {
        return ModelApprovalStatus.fromValue(this.modelApprovalStatus);
    }

    public final String modelApprovalStatusAsString() {
        return this.modelApprovalStatus;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final MetadataProperties metadataProperties() {
        return this.metadataProperties;
    }

    public final ModelMetrics modelMetrics() {
        return this.modelMetrics;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final String approvalDescription() {
        return this.approvalDescription;
    }

    public final String domain() {
        return this.domain;
    }

    public final String task() {
        return this.task;
    }

    public final String samplePayloadUrl() {
        return this.samplePayloadUrl;
    }

    public final boolean hasAdditionalInferenceSpecifications() {
        return this.additionalInferenceSpecifications != null && !(this.additionalInferenceSpecifications instanceof SdkAutoConstructList);
    }

    public final List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications() {
        return this.additionalInferenceSpecifications;
    }

    public final String sourceUri() {
        return this.sourceUri;
    }

    public final ModelPackageSecurityConfig securityConfig() {
        return this.securityConfig;
    }

    public final ModelPackageModelCard modelCard() {
        return this.modelCard;
    }

    public final ModelLifeCycle modelLifeCycle() {
        return this.modelLifeCycle;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasCustomerMetadataProperties() {
        return this.customerMetadataProperties != null && !(this.customerMetadataProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customerMetadataProperties() {
        return this.customerMetadataProperties;
    }

    public final DriftCheckBaselines driftCheckBaselines() {
        return this.driftCheckBaselines;
    }

    public final SkipModelValidation skipModelValidation() {
        return SkipModelValidation.fromValue(this.skipModelValidation);
    }

    public final String skipModelValidationAsString() {
        return this.skipModelValidation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAlgorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.certifyForMarketplace());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelApprovalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.task());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplePayloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalInferenceSpecifications() ? this.additionalInferenceSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCard());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelLifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerMetadataProperties() ? this.customerMetadataProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.driftCheckBaselines());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipModelValidationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackage)) {
            return false;
        }
        ModelPackage other = (ModelPackage)obj;
        return Objects.equals(this.modelPackageName(), other.modelPackageName()) && Objects.equals(this.modelPackageGroupName(), other.modelPackageGroupName()) && Objects.equals(this.modelPackageVersion(), other.modelPackageVersion()) && Objects.equals(this.modelPackageArn(), other.modelPackageArn()) && Objects.equals(this.modelPackageDescription(), other.modelPackageDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.inferenceSpecification(), other.inferenceSpecification()) && Objects.equals(this.sourceAlgorithmSpecification(), other.sourceAlgorithmSpecification()) && Objects.equals(this.validationSpecification(), other.validationSpecification()) && Objects.equals(this.modelPackageStatusAsString(), other.modelPackageStatusAsString()) && Objects.equals(this.modelPackageStatusDetails(), other.modelPackageStatusDetails()) && Objects.equals(this.certifyForMarketplace(), other.certifyForMarketplace()) && Objects.equals(this.modelApprovalStatusAsString(), other.modelApprovalStatusAsString()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.metadataProperties(), other.metadataProperties()) && Objects.equals(this.modelMetrics(), other.modelMetrics()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.approvalDescription(), other.approvalDescription()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.task(), other.task()) && Objects.equals(this.samplePayloadUrl(), other.samplePayloadUrl()) && this.hasAdditionalInferenceSpecifications() == other.hasAdditionalInferenceSpecifications() && Objects.equals(this.additionalInferenceSpecifications(), other.additionalInferenceSpecifications()) && Objects.equals(this.sourceUri(), other.sourceUri()) && Objects.equals(this.securityConfig(), other.securityConfig()) && Objects.equals(this.modelCard(), other.modelCard()) && Objects.equals(this.modelLifeCycle(), other.modelLifeCycle()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasCustomerMetadataProperties() == other.hasCustomerMetadataProperties() && Objects.equals(this.customerMetadataProperties(), other.customerMetadataProperties()) && Objects.equals(this.driftCheckBaselines(), other.driftCheckBaselines()) && Objects.equals(this.skipModelValidationAsString(), other.skipModelValidationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModelPackage").add("ModelPackageName", (Object)this.modelPackageName()).add("ModelPackageGroupName", (Object)this.modelPackageGroupName()).add("ModelPackageVersion", (Object)this.modelPackageVersion()).add("ModelPackageArn", (Object)this.modelPackageArn()).add("ModelPackageDescription", (Object)this.modelPackageDescription()).add("CreationTime", (Object)this.creationTime()).add("InferenceSpecification", (Object)this.inferenceSpecification()).add("SourceAlgorithmSpecification", (Object)this.sourceAlgorithmSpecification()).add("ValidationSpecification", (Object)this.validationSpecification()).add("ModelPackageStatus", (Object)this.modelPackageStatusAsString()).add("ModelPackageStatusDetails", (Object)this.modelPackageStatusDetails()).add("CertifyForMarketplace", (Object)this.certifyForMarketplace()).add("ModelApprovalStatus", (Object)this.modelApprovalStatusAsString()).add("CreatedBy", (Object)this.createdBy()).add("MetadataProperties", (Object)this.metadataProperties()).add("ModelMetrics", (Object)this.modelMetrics()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("ApprovalDescription", (Object)this.approvalDescription()).add("Domain", (Object)this.domain()).add("Task", (Object)this.task()).add("SamplePayloadUrl", (Object)this.samplePayloadUrl()).add("AdditionalInferenceSpecifications", this.hasAdditionalInferenceSpecifications() ? this.additionalInferenceSpecifications() : null).add("SourceUri", (Object)this.sourceUri()).add("SecurityConfig", (Object)this.securityConfig()).add("ModelCard", (Object)this.modelCard()).add("ModelLifeCycle", (Object)this.modelLifeCycle()).add("Tags", this.hasTags() ? this.tags() : null).add("CustomerMetadataProperties", this.hasCustomerMetadataProperties() ? this.customerMetadataProperties() : null).add("DriftCheckBaselines", (Object)this.driftCheckBaselines()).add("SkipModelValidation", (Object)this.skipModelValidationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageName()));
            }
            case "ModelPackageGroupName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupName()));
            }
            case "ModelPackageVersion": {
                return Optional.ofNullable(clazz.cast(this.modelPackageVersion()));
            }
            case "ModelPackageArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageArn()));
            }
            case "ModelPackageDescription": {
                return Optional.ofNullable(clazz.cast(this.modelPackageDescription()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "InferenceSpecification": {
                return Optional.ofNullable(clazz.cast(this.inferenceSpecification()));
            }
            case "SourceAlgorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.sourceAlgorithmSpecification()));
            }
            case "ValidationSpecification": {
                return Optional.ofNullable(clazz.cast(this.validationSpecification()));
            }
            case "ModelPackageStatus": {
                return Optional.ofNullable(clazz.cast(this.modelPackageStatusAsString()));
            }
            case "ModelPackageStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.modelPackageStatusDetails()));
            }
            case "CertifyForMarketplace": {
                return Optional.ofNullable(clazz.cast(this.certifyForMarketplace()));
            }
            case "ModelApprovalStatus": {
                return Optional.ofNullable(clazz.cast(this.modelApprovalStatusAsString()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "MetadataProperties": {
                return Optional.ofNullable(clazz.cast(this.metadataProperties()));
            }
            case "ModelMetrics": {
                return Optional.ofNullable(clazz.cast(this.modelMetrics()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "ApprovalDescription": {
                return Optional.ofNullable(clazz.cast(this.approvalDescription()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Task": {
                return Optional.ofNullable(clazz.cast(this.task()));
            }
            case "SamplePayloadUrl": {
                return Optional.ofNullable(clazz.cast(this.samplePayloadUrl()));
            }
            case "AdditionalInferenceSpecifications": {
                return Optional.ofNullable(clazz.cast(this.additionalInferenceSpecifications()));
            }
            case "SourceUri": {
                return Optional.ofNullable(clazz.cast(this.sourceUri()));
            }
            case "SecurityConfig": {
                return Optional.ofNullable(clazz.cast(this.securityConfig()));
            }
            case "ModelCard": {
                return Optional.ofNullable(clazz.cast(this.modelCard()));
            }
            case "ModelLifeCycle": {
                return Optional.ofNullable(clazz.cast(this.modelLifeCycle()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CustomerMetadataProperties": {
                return Optional.ofNullable(clazz.cast(this.customerMetadataProperties()));
            }
            case "DriftCheckBaselines": {
                return Optional.ofNullable(clazz.cast(this.driftCheckBaselines()));
            }
            case "SkipModelValidation": {
                return Optional.ofNullable(clazz.cast(this.skipModelValidationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackage, T> g) {
        return obj -> g.apply((ModelPackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelPackageName;
        private String modelPackageGroupName;
        private Integer modelPackageVersion;
        private String modelPackageArn;
        private String modelPackageDescription;
        private Instant creationTime;
        private InferenceSpecification inferenceSpecification;
        private SourceAlgorithmSpecification sourceAlgorithmSpecification;
        private ModelPackageValidationSpecification validationSpecification;
        private String modelPackageStatus;
        private ModelPackageStatusDetails modelPackageStatusDetails;
        private Boolean certifyForMarketplace;
        private String modelApprovalStatus;
        private UserContext createdBy;
        private MetadataProperties metadataProperties;
        private ModelMetrics modelMetrics;
        private Instant lastModifiedTime;
        private UserContext lastModifiedBy;
        private String approvalDescription;
        private String domain;
        private String task;
        private String samplePayloadUrl;
        private List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String sourceUri;
        private ModelPackageSecurityConfig securityConfig;
        private ModelPackageModelCard modelCard;
        private ModelLifeCycle modelLifeCycle;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> customerMetadataProperties = DefaultSdkAutoConstructMap.getInstance();
        private DriftCheckBaselines driftCheckBaselines;
        private String skipModelValidation;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackage model) {
            this.modelPackageName(model.modelPackageName);
            this.modelPackageGroupName(model.modelPackageGroupName);
            this.modelPackageVersion(model.modelPackageVersion);
            this.modelPackageArn(model.modelPackageArn);
            this.modelPackageDescription(model.modelPackageDescription);
            this.creationTime(model.creationTime);
            this.inferenceSpecification(model.inferenceSpecification);
            this.sourceAlgorithmSpecification(model.sourceAlgorithmSpecification);
            this.validationSpecification(model.validationSpecification);
            this.modelPackageStatus(model.modelPackageStatus);
            this.modelPackageStatusDetails(model.modelPackageStatusDetails);
            this.certifyForMarketplace(model.certifyForMarketplace);
            this.modelApprovalStatus(model.modelApprovalStatus);
            this.createdBy(model.createdBy);
            this.metadataProperties(model.metadataProperties);
            this.modelMetrics(model.modelMetrics);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.approvalDescription(model.approvalDescription);
            this.domain(model.domain);
            this.task(model.task);
            this.samplePayloadUrl(model.samplePayloadUrl);
            this.additionalInferenceSpecifications(model.additionalInferenceSpecifications);
            this.sourceUri(model.sourceUri);
            this.securityConfig(model.securityConfig);
            this.modelCard(model.modelCard);
            this.modelLifeCycle(model.modelLifeCycle);
            this.tags(model.tags);
            this.customerMetadataProperties(model.customerMetadataProperties);
            this.driftCheckBaselines(model.driftCheckBaselines);
            this.skipModelValidation(model.skipModelValidation);
        }

        public final String getModelPackageName() {
            return this.modelPackageName;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final String getModelPackageGroupName() {
            return this.modelPackageGroupName;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final Integer getModelPackageVersion() {
            return this.modelPackageVersion;
        }

        public final void setModelPackageVersion(Integer modelPackageVersion) {
            this.modelPackageVersion = modelPackageVersion;
        }

        @Override
        public final Builder modelPackageVersion(Integer modelPackageVersion) {
            this.modelPackageVersion = modelPackageVersion;
            return this;
        }

        public final String getModelPackageArn() {
            return this.modelPackageArn;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        @Override
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final String getModelPackageDescription() {
            return this.modelPackageDescription;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        @Override
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return this.inferenceSpecification != null ? this.inferenceSpecification.toBuilder() : null;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final SourceAlgorithmSpecification.Builder getSourceAlgorithmSpecification() {
            return this.sourceAlgorithmSpecification != null ? this.sourceAlgorithmSpecification.toBuilder() : null;
        }

        public final void setSourceAlgorithmSpecification(SourceAlgorithmSpecification.BuilderImpl sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.build() : null;
        }

        @Override
        public final Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification;
            return this;
        }

        public final ModelPackageValidationSpecification.Builder getValidationSpecification() {
            return this.validationSpecification != null ? this.validationSpecification.toBuilder() : null;
        }

        public final void setValidationSpecification(ModelPackageValidationSpecification.BuilderImpl validationSpecification) {
            this.validationSpecification = validationSpecification != null ? validationSpecification.build() : null;
        }

        @Override
        public final Builder validationSpecification(ModelPackageValidationSpecification validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        public final String getModelPackageStatus() {
            return this.modelPackageStatus;
        }

        public final void setModelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
        }

        @Override
        public final Builder modelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
            return this;
        }

        @Override
        public final Builder modelPackageStatus(ModelPackageStatus modelPackageStatus) {
            this.modelPackageStatus(modelPackageStatus == null ? null : modelPackageStatus.toString());
            return this;
        }

        public final ModelPackageStatusDetails.Builder getModelPackageStatusDetails() {
            return this.modelPackageStatusDetails != null ? this.modelPackageStatusDetails.toBuilder() : null;
        }

        public final void setModelPackageStatusDetails(ModelPackageStatusDetails.BuilderImpl modelPackageStatusDetails) {
            this.modelPackageStatusDetails = modelPackageStatusDetails != null ? modelPackageStatusDetails.build() : null;
        }

        @Override
        public final Builder modelPackageStatusDetails(ModelPackageStatusDetails modelPackageStatusDetails) {
            this.modelPackageStatusDetails = modelPackageStatusDetails;
            return this;
        }

        public final Boolean getCertifyForMarketplace() {
            return this.certifyForMarketplace;
        }

        public final void setCertifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
        }

        @Override
        public final Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        public final String getModelApprovalStatus() {
            return this.modelApprovalStatus;
        }

        public final void setModelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
        }

        @Override
        public final Builder modelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        @Override
        public final Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
            this.modelApprovalStatus(modelApprovalStatus == null ? null : modelApprovalStatus.toString());
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return this.metadataProperties != null ? this.metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final ModelMetrics.Builder getModelMetrics() {
            return this.modelMetrics != null ? this.modelMetrics.toBuilder() : null;
        }

        public final void setModelMetrics(ModelMetrics.BuilderImpl modelMetrics) {
            this.modelMetrics = modelMetrics != null ? modelMetrics.build() : null;
        }

        @Override
        public final Builder modelMetrics(ModelMetrics modelMetrics) {
            this.modelMetrics = modelMetrics;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getApprovalDescription() {
            return this.approvalDescription;
        }

        public final void setApprovalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
        }

        @Override
        public final Builder approvalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getTask() {
            return this.task;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final String getSamplePayloadUrl() {
            return this.samplePayloadUrl;
        }

        public final void setSamplePayloadUrl(String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
        }

        @Override
        public final Builder samplePayloadUrl(String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
            return this;
        }

        public final List<AdditionalInferenceSpecificationDefinition.Builder> getAdditionalInferenceSpecifications() {
            List<AdditionalInferenceSpecificationDefinition.Builder> result = AdditionalInferenceSpecificationsCopier.copyToBuilder(this.additionalInferenceSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalInferenceSpecifications(Collection<AdditionalInferenceSpecificationDefinition.BuilderImpl> additionalInferenceSpecifications) {
            this.additionalInferenceSpecifications = AdditionalInferenceSpecificationsCopier.copyFromBuilder(additionalInferenceSpecifications);
        }

        @Override
        public final Builder additionalInferenceSpecifications(Collection<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecifications) {
            this.additionalInferenceSpecifications = AdditionalInferenceSpecificationsCopier.copy(additionalInferenceSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalInferenceSpecifications(AdditionalInferenceSpecificationDefinition ... additionalInferenceSpecifications) {
            this.additionalInferenceSpecifications(Arrays.asList(additionalInferenceSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalInferenceSpecifications(Consumer<AdditionalInferenceSpecificationDefinition.Builder> ... additionalInferenceSpecifications) {
            this.additionalInferenceSpecifications(Stream.of(additionalInferenceSpecifications).map(c -> (AdditionalInferenceSpecificationDefinition)((AdditionalInferenceSpecificationDefinition.Builder)AdditionalInferenceSpecificationDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceUri() {
            return this.sourceUri;
        }

        public final void setSourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
        }

        @Override
        public final Builder sourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
            return this;
        }

        public final ModelPackageSecurityConfig.Builder getSecurityConfig() {
            return this.securityConfig != null ? this.securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(ModelPackageSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        public final Builder securityConfig(ModelPackageSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final ModelPackageModelCard.Builder getModelCard() {
            return this.modelCard != null ? this.modelCard.toBuilder() : null;
        }

        public final void setModelCard(ModelPackageModelCard.BuilderImpl modelCard) {
            this.modelCard = modelCard != null ? modelCard.build() : null;
        }

        @Override
        public final Builder modelCard(ModelPackageModelCard modelCard) {
            this.modelCard = modelCard;
            return this;
        }

        public final ModelLifeCycle.Builder getModelLifeCycle() {
            return this.modelLifeCycle != null ? this.modelLifeCycle.toBuilder() : null;
        }

        public final void setModelLifeCycle(ModelLifeCycle.BuilderImpl modelLifeCycle) {
            this.modelLifeCycle = modelLifeCycle != null ? modelLifeCycle.build() : null;
        }

        @Override
        public final Builder modelLifeCycle(ModelLifeCycle modelLifeCycle) {
            this.modelLifeCycle = modelLifeCycle;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getCustomerMetadataProperties() {
            if (this.customerMetadataProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customerMetadataProperties;
        }

        public final void setCustomerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
        }

        @Override
        public final Builder customerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
            return this;
        }

        public final DriftCheckBaselines.Builder getDriftCheckBaselines() {
            return this.driftCheckBaselines != null ? this.driftCheckBaselines.toBuilder() : null;
        }

        public final void setDriftCheckBaselines(DriftCheckBaselines.BuilderImpl driftCheckBaselines) {
            this.driftCheckBaselines = driftCheckBaselines != null ? driftCheckBaselines.build() : null;
        }

        @Override
        public final Builder driftCheckBaselines(DriftCheckBaselines driftCheckBaselines) {
            this.driftCheckBaselines = driftCheckBaselines;
            return this;
        }

        public final String getSkipModelValidation() {
            return this.skipModelValidation;
        }

        public final void setSkipModelValidation(String skipModelValidation) {
            this.skipModelValidation = skipModelValidation;
        }

        @Override
        public final Builder skipModelValidation(String skipModelValidation) {
            this.skipModelValidation = skipModelValidation;
            return this;
        }

        @Override
        public final Builder skipModelValidation(SkipModelValidation skipModelValidation) {
            this.skipModelValidation(skipModelValidation == null ? null : skipModelValidation.toString());
            return this;
        }

        public ModelPackage build() {
            return new ModelPackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelPackage> {
        public Builder modelPackageName(String var1);

        public Builder modelPackageGroupName(String var1);

        public Builder modelPackageVersion(Integer var1);

        public Builder modelPackageArn(String var1);

        public Builder modelPackageDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder inferenceSpecification(InferenceSpecification var1);

        default public Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return this.inferenceSpecification((InferenceSpecification)((InferenceSpecification.Builder)InferenceSpecification.builder().applyMutation(inferenceSpecification)).build());
        }

        public Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification var1);

        default public Builder sourceAlgorithmSpecification(Consumer<SourceAlgorithmSpecification.Builder> sourceAlgorithmSpecification) {
            return this.sourceAlgorithmSpecification((SourceAlgorithmSpecification)((SourceAlgorithmSpecification.Builder)SourceAlgorithmSpecification.builder().applyMutation(sourceAlgorithmSpecification)).build());
        }

        public Builder validationSpecification(ModelPackageValidationSpecification var1);

        default public Builder validationSpecification(Consumer<ModelPackageValidationSpecification.Builder> validationSpecification) {
            return this.validationSpecification((ModelPackageValidationSpecification)((ModelPackageValidationSpecification.Builder)ModelPackageValidationSpecification.builder().applyMutation(validationSpecification)).build());
        }

        public Builder modelPackageStatus(String var1);

        public Builder modelPackageStatus(ModelPackageStatus var1);

        public Builder modelPackageStatusDetails(ModelPackageStatusDetails var1);

        default public Builder modelPackageStatusDetails(Consumer<ModelPackageStatusDetails.Builder> modelPackageStatusDetails) {
            return this.modelPackageStatusDetails((ModelPackageStatusDetails)((ModelPackageStatusDetails.Builder)ModelPackageStatusDetails.builder().applyMutation(modelPackageStatusDetails)).build());
        }

        public Builder certifyForMarketplace(Boolean var1);

        public Builder modelApprovalStatus(String var1);

        public Builder modelApprovalStatus(ModelApprovalStatus var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder metadataProperties(MetadataProperties var1);

        default public Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return this.metadataProperties((MetadataProperties)((MetadataProperties.Builder)MetadataProperties.builder().applyMutation(metadataProperties)).build());
        }

        public Builder modelMetrics(ModelMetrics var1);

        default public Builder modelMetrics(Consumer<ModelMetrics.Builder> modelMetrics) {
            return this.modelMetrics((ModelMetrics)((ModelMetrics.Builder)ModelMetrics.builder().applyMutation(modelMetrics)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }

        public Builder approvalDescription(String var1);

        public Builder domain(String var1);

        public Builder task(String var1);

        public Builder samplePayloadUrl(String var1);

        public Builder additionalInferenceSpecifications(Collection<AdditionalInferenceSpecificationDefinition> var1);

        public Builder additionalInferenceSpecifications(AdditionalInferenceSpecificationDefinition ... var1);

        public Builder additionalInferenceSpecifications(Consumer<AdditionalInferenceSpecificationDefinition.Builder> ... var1);

        public Builder sourceUri(String var1);

        public Builder securityConfig(ModelPackageSecurityConfig var1);

        default public Builder securityConfig(Consumer<ModelPackageSecurityConfig.Builder> securityConfig) {
            return this.securityConfig((ModelPackageSecurityConfig)((ModelPackageSecurityConfig.Builder)ModelPackageSecurityConfig.builder().applyMutation(securityConfig)).build());
        }

        public Builder modelCard(ModelPackageModelCard var1);

        default public Builder modelCard(Consumer<ModelPackageModelCard.Builder> modelCard) {
            return this.modelCard((ModelPackageModelCard)((ModelPackageModelCard.Builder)ModelPackageModelCard.builder().applyMutation(modelCard)).build());
        }

        public Builder modelLifeCycle(ModelLifeCycle var1);

        default public Builder modelLifeCycle(Consumer<ModelLifeCycle.Builder> modelLifeCycle) {
            return this.modelLifeCycle((ModelLifeCycle)((ModelLifeCycle.Builder)ModelLifeCycle.builder().applyMutation(modelLifeCycle)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder customerMetadataProperties(Map<String, String> var1);

        public Builder driftCheckBaselines(DriftCheckBaselines var1);

        default public Builder driftCheckBaselines(Consumer<DriftCheckBaselines.Builder> driftCheckBaselines) {
            return this.driftCheckBaselines((DriftCheckBaselines)((DriftCheckBaselines.Builder)DriftCheckBaselines.builder().applyMutation(driftCheckBaselines)).build());
        }

        public Builder skipModelValidation(String var1);

        public Builder skipModelValidation(SkipModelValidation var1);
    }
}

