/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndpointSortKey {
    NAME("Name"),
    CREATION_TIME("CreationTime"),
    STATUS("Status"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndpointSortKey> VALUE_MAP;
    private final String value;

    private EndpointSortKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointSortKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointSortKey> knownValues() {
        EnumSet<EndpointSortKey> knownValues = EnumSet.allOf(EndpointSortKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndpointSortKey.class, EndpointSortKey::toString);
    }
}

