/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Resource;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOfResourceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceSetRequest
extends Route53RecoveryReadinessRequest
implements ToCopyableBuilder<Builder, UpdateResourceSetRequest> {
    private static final SdkField<String> RESOURCE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSetName").getter(UpdateResourceSetRequest.getter(UpdateResourceSetRequest::resourceSetName)).setter(UpdateResourceSetRequest.setter(Builder::resourceSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceSetName").build()}).build();
    private static final SdkField<String> RESOURCE_SET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSetType").getter(UpdateResourceSetRequest.getter(UpdateResourceSetRequest::resourceSetType)).setter(UpdateResourceSetRequest.setter(Builder::resourceSetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSetType").build()}).build();
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(UpdateResourceSetRequest.getter(UpdateResourceSetRequest::resources)).setter(UpdateResourceSetRequest.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SET_NAME_FIELD, RESOURCE_SET_TYPE_FIELD, RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceSetName", RESOURCE_SET_NAME_FIELD);
            this.put("resourceSetType", RESOURCE_SET_TYPE_FIELD);
            this.put("resources", RESOURCES_FIELD);
        }
    });
    private final String resourceSetName;
    private final String resourceSetType;
    private final List<Resource> resources;

    private UpdateResourceSetRequest(BuilderImpl builder) {
        super(builder);
        this.resourceSetName = builder.resourceSetName;
        this.resourceSetType = builder.resourceSetType;
        this.resources = builder.resources;
    }

    public final String resourceSetName() {
        return this.resourceSetName;
    }

    public final String resourceSetType() {
        return this.resourceSetType;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<Resource> resources() {
        return this.resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceSetRequest)) {
            return false;
        }
        UpdateResourceSetRequest other = (UpdateResourceSetRequest)((Object)obj);
        return Objects.equals(this.resourceSetName(), other.resourceSetName()) && Objects.equals(this.resourceSetType(), other.resourceSetType()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResourceSetRequest").add("ResourceSetName", (Object)this.resourceSetName()).add("ResourceSetType", (Object)this.resourceSetType()).add("Resources", this.hasResources() ? this.resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceSetName": {
                return Optional.ofNullable(clazz.cast(this.resourceSetName()));
            }
            case "ResourceSetType": {
                return Optional.ofNullable(clazz.cast(this.resourceSetType()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceSetRequest, T> g) {
        return obj -> g.apply((UpdateResourceSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessRequest.BuilderImpl
    implements Builder {
        private String resourceSetName;
        private String resourceSetType;
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceSetRequest model) {
            super(model);
            this.resourceSetName(model.resourceSetName);
            this.resourceSetType(model.resourceSetType);
            this.resources(model.resources);
        }

        public final String getResourceSetName() {
            return this.resourceSetName;
        }

        public final void setResourceSetName(String resourceSetName) {
            this.resourceSetName = resourceSetName;
        }

        @Override
        public final Builder resourceSetName(String resourceSetName) {
            this.resourceSetName = resourceSetName;
            return this;
        }

        public final String getResourceSetType() {
            return this.resourceSetType;
        }

        public final void setResourceSetType(String resourceSetType) {
            this.resourceSetType = resourceSetType;
        }

        @Override
        public final Builder resourceSetType(String resourceSetType) {
            this.resourceSetType = resourceSetType;
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ___listOfResourceCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ___listOfResourceCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ___listOfResourceCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceSetRequest build() {
            return new UpdateResourceSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53RecoveryReadinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResourceSetRequest> {
        public Builder resourceSetName(String var1);

        public Builder resourceSetType(String var1);

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);

        public Builder resources(Consumer<Resource.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

