/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.NewAssertionRule;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.NewGatingRule;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Route53RecoveryControlConfigRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.___mapOf__stringMin0Max256PatternSCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSafetyRuleRequest
extends Route53RecoveryControlConfigRequest
implements ToCopyableBuilder<Builder, CreateSafetyRuleRequest> {
    private static final SdkField<NewAssertionRule> ASSERTION_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssertionRule").getter(CreateSafetyRuleRequest.getter(CreateSafetyRuleRequest::assertionRule)).setter(CreateSafetyRuleRequest.setter(Builder::assertionRule)).constructor(NewAssertionRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssertionRule").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateSafetyRuleRequest.getter(CreateSafetyRuleRequest::clientToken)).setter(CreateSafetyRuleRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<NewGatingRule> GATING_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GatingRule").getter(CreateSafetyRuleRequest.getter(CreateSafetyRuleRequest::gatingRule)).setter(CreateSafetyRuleRequest.setter(Builder::gatingRule)).constructor(NewGatingRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatingRule").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateSafetyRuleRequest.getter(CreateSafetyRuleRequest::tags)).setter(CreateSafetyRuleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSERTION_RULE_FIELD, CLIENT_TOKEN_FIELD, GATING_RULE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AssertionRule", ASSERTION_RULE_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("GatingRule", GATING_RULE_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final NewAssertionRule assertionRule;
    private final String clientToken;
    private final NewGatingRule gatingRule;
    private final Map<String, String> tags;

    private CreateSafetyRuleRequest(BuilderImpl builder) {
        super(builder);
        this.assertionRule = builder.assertionRule;
        this.clientToken = builder.clientToken;
        this.gatingRule = builder.gatingRule;
        this.tags = builder.tags;
    }

    public final NewAssertionRule assertionRule() {
        return this.assertionRule;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final NewGatingRule gatingRule() {
        return this.gatingRule;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assertionRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatingRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSafetyRuleRequest)) {
            return false;
        }
        CreateSafetyRuleRequest other = (CreateSafetyRuleRequest)((Object)obj);
        return Objects.equals(this.assertionRule(), other.assertionRule()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.gatingRule(), other.gatingRule()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSafetyRuleRequest").add("AssertionRule", (Object)this.assertionRule()).add("ClientToken", (Object)this.clientToken()).add("GatingRule", (Object)this.gatingRule()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssertionRule": {
                return Optional.ofNullable(clazz.cast(this.assertionRule()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "GatingRule": {
                return Optional.ofNullable(clazz.cast(this.gatingRule()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSafetyRuleRequest, T> g) {
        return obj -> g.apply((CreateSafetyRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryControlConfigRequest.BuilderImpl
    implements Builder {
        private NewAssertionRule assertionRule;
        private String clientToken;
        private NewGatingRule gatingRule;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSafetyRuleRequest model) {
            super(model);
            this.assertionRule(model.assertionRule);
            this.clientToken(model.clientToken);
            this.gatingRule(model.gatingRule);
            this.tags(model.tags);
        }

        public final NewAssertionRule.Builder getAssertionRule() {
            return this.assertionRule != null ? this.assertionRule.toBuilder() : null;
        }

        public final void setAssertionRule(NewAssertionRule.BuilderImpl assertionRule) {
            this.assertionRule = assertionRule != null ? assertionRule.build() : null;
        }

        @Override
        public final Builder assertionRule(NewAssertionRule assertionRule) {
            this.assertionRule = assertionRule;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final NewGatingRule.Builder getGatingRule() {
            return this.gatingRule != null ? this.gatingRule.toBuilder() : null;
        }

        public final void setGatingRule(NewGatingRule.BuilderImpl gatingRule) {
            this.gatingRule = gatingRule != null ? gatingRule.build() : null;
        }

        @Override
        public final Builder gatingRule(NewGatingRule gatingRule) {
            this.gatingRule = gatingRule;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringMin0Max256PatternSCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringMin0Max256PatternSCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSafetyRuleRequest build() {
            return new CreateSafetyRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53RecoveryControlConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSafetyRuleRequest> {
        public Builder assertionRule(NewAssertionRule var1);

        default public Builder assertionRule(Consumer<NewAssertionRule.Builder> assertionRule) {
            return this.assertionRule((NewAssertionRule)((NewAssertionRule.Builder)NewAssertionRule.builder().applyMutation(assertionRule)).build());
        }

        public Builder clientToken(String var1);

        public Builder gatingRule(NewGatingRule var1);

        default public Builder gatingRule(Consumer<NewGatingRule.Builder> gatingRule) {
            return this.gatingRule((NewGatingRule)((NewGatingRule.Builder)NewGatingRule.builder().applyMutation(gatingRule)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

