/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse;
import software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary;

public class ListWorldGenerationJobsIterable
implements SdkIterable<ListWorldGenerationJobsResponse> {
    private final RoboMakerClient client;
    private final ListWorldGenerationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorldGenerationJobsIterable(RoboMakerClient client, ListWorldGenerationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorldGenerationJobsResponseFetcher();
    }

    public Iterator<ListWorldGenerationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorldGenerationJobSummary> worldGenerationJobSummaries() {
        Function<ListWorldGenerationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.worldGenerationJobSummaries() != null) {
                return response.worldGenerationJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorldGenerationJobsResponseFetcher
    implements SyncPageFetcher<ListWorldGenerationJobsResponse> {
        private ListWorldGenerationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorldGenerationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorldGenerationJobsResponse nextPage(ListWorldGenerationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListWorldGenerationJobsIterable.this.client.listWorldGenerationJobs(ListWorldGenerationJobsIterable.this.firstRequest);
            }
            return ListWorldGenerationJobsIterable.this.client.listWorldGenerationJobs((ListWorldGenerationJobsRequest)((Object)ListWorldGenerationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

