/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.AppInputSource;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAppInputSourceResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, DeleteAppInputSourceResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(DeleteAppInputSourceResponse.getter(DeleteAppInputSourceResponse::appArn)).setter(DeleteAppInputSourceResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<AppInputSource> APP_INPUT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("appInputSource").getter(DeleteAppInputSourceResponse.getter(DeleteAppInputSourceResponse::appInputSource)).setter(DeleteAppInputSourceResponse.setter(Builder::appInputSource)).constructor(AppInputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appInputSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_INPUT_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appArn", APP_ARN_FIELD);
            this.put("appInputSource", APP_INPUT_SOURCE_FIELD);
        }
    });
    private final String appArn;
    private final AppInputSource appInputSource;

    private DeleteAppInputSourceResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appInputSource = builder.appInputSource;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final AppInputSource appInputSource() {
        return this.appInputSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appInputSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppInputSourceResponse)) {
            return false;
        }
        DeleteAppInputSourceResponse other = (DeleteAppInputSourceResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appInputSource(), other.appInputSource());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAppInputSourceResponse").add("AppArn", (Object)this.appArn()).add("AppInputSource", (Object)this.appInputSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appInputSource": {
                return Optional.ofNullable(clazz.cast(this.appInputSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAppInputSourceResponse, T> g) {
        return obj -> g.apply((DeleteAppInputSourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private AppInputSource appInputSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppInputSourceResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.appInputSource(model.appInputSource);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final AppInputSource.Builder getAppInputSource() {
            return this.appInputSource != null ? this.appInputSource.toBuilder() : null;
        }

        public final void setAppInputSource(AppInputSource.BuilderImpl appInputSource) {
            this.appInputSource = appInputSource != null ? appInputSource.build() : null;
        }

        @Override
        public final Builder appInputSource(AppInputSource appInputSource) {
            this.appInputSource = appInputSource;
            return this;
        }

        @Override
        public DeleteAppInputSourceResponse build() {
            return new DeleteAppInputSourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAppInputSourceResponse> {
        public Builder appArn(String var1);

        public Builder appInputSource(AppInputSource var1);

        default public Builder appInputSource(Consumer<AppInputSource.Builder> appInputSource) {
            return this.appInputSource((AppInputSource)((AppInputSource.Builder)AppInputSource.builder().applyMutation(appInputSource)).build());
        }
    }
}

