/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.TableRestoreStatus;

public class ListTableRestoreStatusPublisher
implements SdkPublisher<ListTableRestoreStatusResponse> {
    private final RedshiftServerlessAsyncClient client;
    private final ListTableRestoreStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTableRestoreStatusPublisher(RedshiftServerlessAsyncClient client, ListTableRestoreStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTableRestoreStatusPublisher(RedshiftServerlessAsyncClient client, ListTableRestoreStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTableRestoreStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTableRestoreStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TableRestoreStatus> tableRestoreStatuses() {
        Function<ListTableRestoreStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableRestoreStatuses() != null) {
                return response.tableRestoreStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTableRestoreStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTableRestoreStatusResponseFetcher
    implements AsyncPageFetcher<ListTableRestoreStatusResponse> {
        private ListTableRestoreStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListTableRestoreStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTableRestoreStatusResponse> nextPage(ListTableRestoreStatusResponse previousPage) {
            if (previousPage == null) {
                return ListTableRestoreStatusPublisher.this.client.listTableRestoreStatus(ListTableRestoreStatusPublisher.this.firstRequest);
            }
            return ListTableRestoreStatusPublisher.this.client.listTableRestoreStatus((ListTableRestoreStatusRequest)((Object)ListTableRestoreStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

