/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshiftserverless.model.TableRestoreStatus;

public class ListTableRestoreStatusIterable
implements SdkIterable<ListTableRestoreStatusResponse> {
    private final RedshiftServerlessClient client;
    private final ListTableRestoreStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTableRestoreStatusIterable(RedshiftServerlessClient client, ListTableRestoreStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTableRestoreStatusResponseFetcher();
    }

    public Iterator<ListTableRestoreStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TableRestoreStatus> tableRestoreStatuses() {
        Function<ListTableRestoreStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableRestoreStatuses() != null) {
                return response.tableRestoreStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTableRestoreStatusResponseFetcher
    implements SyncPageFetcher<ListTableRestoreStatusResponse> {
        private ListTableRestoreStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListTableRestoreStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTableRestoreStatusResponse nextPage(ListTableRestoreStatusResponse previousPage) {
            if (previousPage == null) {
                return ListTableRestoreStatusIterable.this.client.listTableRestoreStatus(ListTableRestoreStatusIterable.this.firstRequest);
            }
            return ListTableRestoreStatusIterable.this.client.listTableRestoreStatus((ListTableRestoreStatusRequest)((Object)ListTableRestoreStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

