/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TopicRefreshStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicRefreshDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicRefreshDetails> {
    private static final SdkField<String> REFRESH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefreshArn").getter(TopicRefreshDetails.getter(TopicRefreshDetails::refreshArn)).setter(TopicRefreshDetails.setter(Builder::refreshArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshArn").build()}).build();
    private static final SdkField<String> REFRESH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefreshId").getter(TopicRefreshDetails.getter(TopicRefreshDetails::refreshId)).setter(TopicRefreshDetails.setter(Builder::refreshId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshId").build()}).build();
    private static final SdkField<String> REFRESH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefreshStatus").getter(TopicRefreshDetails.getter(TopicRefreshDetails::refreshStatusAsString)).setter(TopicRefreshDetails.setter(Builder::refreshStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFRESH_ARN_FIELD, REFRESH_ID_FIELD, REFRESH_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RefreshArn", REFRESH_ARN_FIELD);
            this.put("RefreshId", REFRESH_ID_FIELD);
            this.put("RefreshStatus", REFRESH_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String refreshArn;
    private final String refreshId;
    private final String refreshStatus;

    private TopicRefreshDetails(BuilderImpl builder) {
        this.refreshArn = builder.refreshArn;
        this.refreshId = builder.refreshId;
        this.refreshStatus = builder.refreshStatus;
    }

    public final String refreshArn() {
        return this.refreshArn;
    }

    public final String refreshId() {
        return this.refreshId;
    }

    public final TopicRefreshStatus refreshStatus() {
        return TopicRefreshStatus.fromValue(this.refreshStatus);
    }

    public final String refreshStatusAsString() {
        return this.refreshStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshId());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRefreshDetails)) {
            return false;
        }
        TopicRefreshDetails other = (TopicRefreshDetails)obj;
        return Objects.equals(this.refreshArn(), other.refreshArn()) && Objects.equals(this.refreshId(), other.refreshId()) && Objects.equals(this.refreshStatusAsString(), other.refreshStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TopicRefreshDetails").add("RefreshArn", (Object)this.refreshArn()).add("RefreshId", (Object)this.refreshId()).add("RefreshStatus", (Object)this.refreshStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RefreshArn": {
                return Optional.ofNullable(clazz.cast(this.refreshArn()));
            }
            case "RefreshId": {
                return Optional.ofNullable(clazz.cast(this.refreshId()));
            }
            case "RefreshStatus": {
                return Optional.ofNullable(clazz.cast(this.refreshStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TopicRefreshDetails, T> g) {
        return obj -> g.apply((TopicRefreshDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String refreshArn;
        private String refreshId;
        private String refreshStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRefreshDetails model) {
            this.refreshArn(model.refreshArn);
            this.refreshId(model.refreshId);
            this.refreshStatus(model.refreshStatus);
        }

        public final String getRefreshArn() {
            return this.refreshArn;
        }

        public final void setRefreshArn(String refreshArn) {
            this.refreshArn = refreshArn;
        }

        @Override
        public final Builder refreshArn(String refreshArn) {
            this.refreshArn = refreshArn;
            return this;
        }

        public final String getRefreshId() {
            return this.refreshId;
        }

        public final void setRefreshId(String refreshId) {
            this.refreshId = refreshId;
        }

        @Override
        public final Builder refreshId(String refreshId) {
            this.refreshId = refreshId;
            return this;
        }

        public final String getRefreshStatus() {
            return this.refreshStatus;
        }

        public final void setRefreshStatus(String refreshStatus) {
            this.refreshStatus = refreshStatus;
        }

        @Override
        public final Builder refreshStatus(String refreshStatus) {
            this.refreshStatus = refreshStatus;
            return this;
        }

        @Override
        public final Builder refreshStatus(TopicRefreshStatus refreshStatus) {
            this.refreshStatus(refreshStatus == null ? null : refreshStatus.toString());
            return this;
        }

        public TopicRefreshDetails build() {
            return new TopicRefreshDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicRefreshDetails> {
        public Builder refreshArn(String var1);

        public Builder refreshId(String var1);

        public Builder refreshStatus(String var1);

        public Builder refreshStatus(TopicRefreshStatus var1);
    }
}

