/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CalculatedMeasureField;
import software.amazon.awssdk.services.quicksight.model.CategoricalMeasureField;
import software.amazon.awssdk.services.quicksight.model.DateMeasureField;
import software.amazon.awssdk.services.quicksight.model.NumericalMeasureField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MeasureField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MeasureField> {
    private static final SdkField<NumericalMeasureField> NUMERICAL_MEASURE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NumericalMeasureField").getter(MeasureField.getter(MeasureField::numericalMeasureField)).setter(MeasureField.setter(Builder::numericalMeasureField)).constructor(NumericalMeasureField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericalMeasureField").build()}).build();
    private static final SdkField<CategoricalMeasureField> CATEGORICAL_MEASURE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoricalMeasureField").getter(MeasureField.getter(MeasureField::categoricalMeasureField)).setter(MeasureField.setter(Builder::categoricalMeasureField)).constructor(CategoricalMeasureField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoricalMeasureField").build()}).build();
    private static final SdkField<DateMeasureField> DATE_MEASURE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DateMeasureField").getter(MeasureField.getter(MeasureField::dateMeasureField)).setter(MeasureField.setter(Builder::dateMeasureField)).constructor(DateMeasureField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateMeasureField").build()}).build();
    private static final SdkField<CalculatedMeasureField> CALCULATED_MEASURE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CalculatedMeasureField").getter(MeasureField.getter(MeasureField::calculatedMeasureField)).setter(MeasureField.setter(Builder::calculatedMeasureField)).constructor(CalculatedMeasureField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedMeasureField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMERICAL_MEASURE_FIELD_FIELD, CATEGORICAL_MEASURE_FIELD_FIELD, DATE_MEASURE_FIELD_FIELD, CALCULATED_MEASURE_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NumericalMeasureField", NUMERICAL_MEASURE_FIELD_FIELD);
            this.put("CategoricalMeasureField", CATEGORICAL_MEASURE_FIELD_FIELD);
            this.put("DateMeasureField", DATE_MEASURE_FIELD_FIELD);
            this.put("CalculatedMeasureField", CALCULATED_MEASURE_FIELD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final NumericalMeasureField numericalMeasureField;
    private final CategoricalMeasureField categoricalMeasureField;
    private final DateMeasureField dateMeasureField;
    private final CalculatedMeasureField calculatedMeasureField;

    private MeasureField(BuilderImpl builder) {
        this.numericalMeasureField = builder.numericalMeasureField;
        this.categoricalMeasureField = builder.categoricalMeasureField;
        this.dateMeasureField = builder.dateMeasureField;
        this.calculatedMeasureField = builder.calculatedMeasureField;
    }

    public final NumericalMeasureField numericalMeasureField() {
        return this.numericalMeasureField;
    }

    public final CategoricalMeasureField categoricalMeasureField() {
        return this.categoricalMeasureField;
    }

    public final DateMeasureField dateMeasureField() {
        return this.dateMeasureField;
    }

    public final CalculatedMeasureField calculatedMeasureField() {
        return this.calculatedMeasureField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numericalMeasureField());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoricalMeasureField());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateMeasureField());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedMeasureField());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeasureField)) {
            return false;
        }
        MeasureField other = (MeasureField)obj;
        return Objects.equals(this.numericalMeasureField(), other.numericalMeasureField()) && Objects.equals(this.categoricalMeasureField(), other.categoricalMeasureField()) && Objects.equals(this.dateMeasureField(), other.dateMeasureField()) && Objects.equals(this.calculatedMeasureField(), other.calculatedMeasureField());
    }

    public final String toString() {
        return ToString.builder((String)"MeasureField").add("NumericalMeasureField", (Object)this.numericalMeasureField()).add("CategoricalMeasureField", (Object)this.categoricalMeasureField()).add("DateMeasureField", (Object)this.dateMeasureField()).add("CalculatedMeasureField", (Object)this.calculatedMeasureField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumericalMeasureField": {
                return Optional.ofNullable(clazz.cast(this.numericalMeasureField()));
            }
            case "CategoricalMeasureField": {
                return Optional.ofNullable(clazz.cast(this.categoricalMeasureField()));
            }
            case "DateMeasureField": {
                return Optional.ofNullable(clazz.cast(this.dateMeasureField()));
            }
            case "CalculatedMeasureField": {
                return Optional.ofNullable(clazz.cast(this.calculatedMeasureField()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MeasureField, T> g) {
        return obj -> g.apply((MeasureField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NumericalMeasureField numericalMeasureField;
        private CategoricalMeasureField categoricalMeasureField;
        private DateMeasureField dateMeasureField;
        private CalculatedMeasureField calculatedMeasureField;

        private BuilderImpl() {
        }

        private BuilderImpl(MeasureField model) {
            this.numericalMeasureField(model.numericalMeasureField);
            this.categoricalMeasureField(model.categoricalMeasureField);
            this.dateMeasureField(model.dateMeasureField);
            this.calculatedMeasureField(model.calculatedMeasureField);
        }

        public final NumericalMeasureField.Builder getNumericalMeasureField() {
            return this.numericalMeasureField != null ? this.numericalMeasureField.toBuilder() : null;
        }

        public final void setNumericalMeasureField(NumericalMeasureField.BuilderImpl numericalMeasureField) {
            this.numericalMeasureField = numericalMeasureField != null ? numericalMeasureField.build() : null;
        }

        @Override
        public final Builder numericalMeasureField(NumericalMeasureField numericalMeasureField) {
            this.numericalMeasureField = numericalMeasureField;
            return this;
        }

        public final CategoricalMeasureField.Builder getCategoricalMeasureField() {
            return this.categoricalMeasureField != null ? this.categoricalMeasureField.toBuilder() : null;
        }

        public final void setCategoricalMeasureField(CategoricalMeasureField.BuilderImpl categoricalMeasureField) {
            this.categoricalMeasureField = categoricalMeasureField != null ? categoricalMeasureField.build() : null;
        }

        @Override
        public final Builder categoricalMeasureField(CategoricalMeasureField categoricalMeasureField) {
            this.categoricalMeasureField = categoricalMeasureField;
            return this;
        }

        public final DateMeasureField.Builder getDateMeasureField() {
            return this.dateMeasureField != null ? this.dateMeasureField.toBuilder() : null;
        }

        public final void setDateMeasureField(DateMeasureField.BuilderImpl dateMeasureField) {
            this.dateMeasureField = dateMeasureField != null ? dateMeasureField.build() : null;
        }

        @Override
        public final Builder dateMeasureField(DateMeasureField dateMeasureField) {
            this.dateMeasureField = dateMeasureField;
            return this;
        }

        public final CalculatedMeasureField.Builder getCalculatedMeasureField() {
            return this.calculatedMeasureField != null ? this.calculatedMeasureField.toBuilder() : null;
        }

        public final void setCalculatedMeasureField(CalculatedMeasureField.BuilderImpl calculatedMeasureField) {
            this.calculatedMeasureField = calculatedMeasureField != null ? calculatedMeasureField.build() : null;
        }

        @Override
        public final Builder calculatedMeasureField(CalculatedMeasureField calculatedMeasureField) {
            this.calculatedMeasureField = calculatedMeasureField;
            return this;
        }

        public MeasureField build() {
            return new MeasureField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MeasureField> {
        public Builder numericalMeasureField(NumericalMeasureField var1);

        default public Builder numericalMeasureField(Consumer<NumericalMeasureField.Builder> numericalMeasureField) {
            return this.numericalMeasureField((NumericalMeasureField)((NumericalMeasureField.Builder)NumericalMeasureField.builder().applyMutation(numericalMeasureField)).build());
        }

        public Builder categoricalMeasureField(CategoricalMeasureField var1);

        default public Builder categoricalMeasureField(Consumer<CategoricalMeasureField.Builder> categoricalMeasureField) {
            return this.categoricalMeasureField((CategoricalMeasureField)((CategoricalMeasureField.Builder)CategoricalMeasureField.builder().applyMutation(categoricalMeasureField)).build());
        }

        public Builder dateMeasureField(DateMeasureField var1);

        default public Builder dateMeasureField(Consumer<DateMeasureField.Builder> dateMeasureField) {
            return this.dateMeasureField((DateMeasureField)((DateMeasureField.Builder)DateMeasureField.builder().applyMutation(dateMeasureField)).build());
        }

        public Builder calculatedMeasureField(CalculatedMeasureField var1);

        default public Builder calculatedMeasureField(Consumer<CalculatedMeasureField.Builder> calculatedMeasureField) {
            return this.calculatedMeasureField((CalculatedMeasureField)((CalculatedMeasureField.Builder)CalculatedMeasureField.builder().applyMutation(calculatedMeasureField)).build());
        }
    }
}

