/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.KPISparklineType;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KPISparklineOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KPISparklineOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(KPISparklineOptions.getter(KPISparklineOptions::visibilityAsString)).setter(KPISparklineOptions.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(KPISparklineOptions.getter(KPISparklineOptions::typeAsString)).setter(KPISparklineOptions.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Color").getter(KPISparklineOptions.getter(KPISparklineOptions::color)).setter(KPISparklineOptions.setter(Builder::color)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()}).build();
    private static final SdkField<String> TOOLTIP_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TooltipVisibility").getter(KPISparklineOptions.getter(KPISparklineOptions::tooltipVisibilityAsString)).setter(KPISparklineOptions.setter(Builder::tooltipVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TooltipVisibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD, TYPE_FIELD, COLOR_FIELD, TOOLTIP_VISIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Visibility", VISIBILITY_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("Color", COLOR_FIELD);
            this.put("TooltipVisibility", TOOLTIP_VISIBILITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String visibility;
    private final String type;
    private final String color;
    private final String tooltipVisibility;

    private KPISparklineOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.type = builder.type;
        this.color = builder.color;
        this.tooltipVisibility = builder.tooltipVisibility;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final KPISparklineType type() {
        return KPISparklineType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String color() {
        return this.color;
    }

    public final Visibility tooltipVisibility() {
        return Visibility.fromValue(this.tooltipVisibility);
    }

    public final String tooltipVisibilityAsString() {
        return this.tooltipVisibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.color());
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltipVisibilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPISparklineOptions)) {
            return false;
        }
        KPISparklineOptions other = (KPISparklineOptions)obj;
        return Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.color(), other.color()) && Objects.equals(this.tooltipVisibilityAsString(), other.tooltipVisibilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"KPISparklineOptions").add("Visibility", (Object)this.visibilityAsString()).add("Type", (Object)this.typeAsString()).add("Color", (Object)this.color()).add("TooltipVisibility", (Object)this.tooltipVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Color": {
                return Optional.ofNullable(clazz.cast(this.color()));
            }
            case "TooltipVisibility": {
                return Optional.ofNullable(clazz.cast(this.tooltipVisibilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KPISparklineOptions, T> g) {
        return obj -> g.apply((KPISparklineOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visibility;
        private String type;
        private String color;
        private String tooltipVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(KPISparklineOptions model) {
            this.visibility(model.visibility);
            this.type(model.type);
            this.color(model.color);
            this.tooltipVisibility(model.tooltipVisibility);
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(KPISparklineType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getColor() {
            return this.color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final String getTooltipVisibility() {
            return this.tooltipVisibility;
        }

        public final void setTooltipVisibility(String tooltipVisibility) {
            this.tooltipVisibility = tooltipVisibility;
        }

        @Override
        public final Builder tooltipVisibility(String tooltipVisibility) {
            this.tooltipVisibility = tooltipVisibility;
            return this;
        }

        @Override
        public final Builder tooltipVisibility(Visibility tooltipVisibility) {
            this.tooltipVisibility(tooltipVisibility == null ? null : tooltipVisibility.toString());
            return this;
        }

        public KPISparklineOptions build() {
            return new KPISparklineOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KPISparklineOptions> {
        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder type(String var1);

        public Builder type(KPISparklineType var1);

        public Builder color(String var1);

        public Builder tooltipVisibility(String var1);

        public Builder tooltipVisibility(Visibility var1);
    }
}

