/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ComparisonConfiguration;
import software.amazon.awssdk.services.quicksight.model.FontConfiguration;
import software.amazon.awssdk.services.quicksight.model.KPISparklineOptions;
import software.amazon.awssdk.services.quicksight.model.KPIVisualLayoutOptions;
import software.amazon.awssdk.services.quicksight.model.PrimaryValueDisplayType;
import software.amazon.awssdk.services.quicksight.model.ProgressBarOptions;
import software.amazon.awssdk.services.quicksight.model.SecondaryValueOptions;
import software.amazon.awssdk.services.quicksight.model.TrendArrowOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KPIOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KPIOptions> {
    private static final SdkField<ProgressBarOptions> PROGRESS_BAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProgressBar").getter(KPIOptions.getter(KPIOptions::progressBar)).setter(KPIOptions.setter(Builder::progressBar)).constructor(ProgressBarOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressBar").build()}).build();
    private static final SdkField<TrendArrowOptions> TREND_ARROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrendArrows").getter(KPIOptions.getter(KPIOptions::trendArrows)).setter(KPIOptions.setter(Builder::trendArrows)).constructor(TrendArrowOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrendArrows").build()}).build();
    private static final SdkField<SecondaryValueOptions> SECONDARY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecondaryValue").getter(KPIOptions.getter(KPIOptions::secondaryValue)).setter(KPIOptions.setter(Builder::secondaryValue)).constructor(SecondaryValueOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryValue").build()}).build();
    private static final SdkField<ComparisonConfiguration> COMPARISON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Comparison").getter(KPIOptions.getter(KPIOptions::comparison)).setter(KPIOptions.setter(Builder::comparison)).constructor(ComparisonConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comparison").build()}).build();
    private static final SdkField<String> PRIMARY_VALUE_DISPLAY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryValueDisplayType").getter(KPIOptions.getter(KPIOptions::primaryValueDisplayTypeAsString)).setter(KPIOptions.setter(Builder::primaryValueDisplayType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValueDisplayType").build()}).build();
    private static final SdkField<FontConfiguration> PRIMARY_VALUE_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryValueFontConfiguration").getter(KPIOptions.getter(KPIOptions::primaryValueFontConfiguration)).setter(KPIOptions.setter(Builder::primaryValueFontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValueFontConfiguration").build()}).build();
    private static final SdkField<FontConfiguration> SECONDARY_VALUE_FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecondaryValueFontConfiguration").getter(KPIOptions.getter(KPIOptions::secondaryValueFontConfiguration)).setter(KPIOptions.setter(Builder::secondaryValueFontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryValueFontConfiguration").build()}).build();
    private static final SdkField<KPISparklineOptions> SPARKLINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sparkline").getter(KPIOptions.getter(KPIOptions::sparkline)).setter(KPIOptions.setter(Builder::sparkline)).constructor(KPISparklineOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sparkline").build()}).build();
    private static final SdkField<KPIVisualLayoutOptions> VISUAL_LAYOUT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualLayoutOptions").getter(KPIOptions.getter(KPIOptions::visualLayoutOptions)).setter(KPIOptions.setter(Builder::visualLayoutOptions)).constructor(KPIVisualLayoutOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualLayoutOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_BAR_FIELD, TREND_ARROWS_FIELD, SECONDARY_VALUE_FIELD, COMPARISON_FIELD, PRIMARY_VALUE_DISPLAY_TYPE_FIELD, PRIMARY_VALUE_FONT_CONFIGURATION_FIELD, SECONDARY_VALUE_FONT_CONFIGURATION_FIELD, SPARKLINE_FIELD, VISUAL_LAYOUT_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProgressBar", PROGRESS_BAR_FIELD);
            this.put("TrendArrows", TREND_ARROWS_FIELD);
            this.put("SecondaryValue", SECONDARY_VALUE_FIELD);
            this.put("Comparison", COMPARISON_FIELD);
            this.put("PrimaryValueDisplayType", PRIMARY_VALUE_DISPLAY_TYPE_FIELD);
            this.put("PrimaryValueFontConfiguration", PRIMARY_VALUE_FONT_CONFIGURATION_FIELD);
            this.put("SecondaryValueFontConfiguration", SECONDARY_VALUE_FONT_CONFIGURATION_FIELD);
            this.put("Sparkline", SPARKLINE_FIELD);
            this.put("VisualLayoutOptions", VISUAL_LAYOUT_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ProgressBarOptions progressBar;
    private final TrendArrowOptions trendArrows;
    private final SecondaryValueOptions secondaryValue;
    private final ComparisonConfiguration comparison;
    private final String primaryValueDisplayType;
    private final FontConfiguration primaryValueFontConfiguration;
    private final FontConfiguration secondaryValueFontConfiguration;
    private final KPISparklineOptions sparkline;
    private final KPIVisualLayoutOptions visualLayoutOptions;

    private KPIOptions(BuilderImpl builder) {
        this.progressBar = builder.progressBar;
        this.trendArrows = builder.trendArrows;
        this.secondaryValue = builder.secondaryValue;
        this.comparison = builder.comparison;
        this.primaryValueDisplayType = builder.primaryValueDisplayType;
        this.primaryValueFontConfiguration = builder.primaryValueFontConfiguration;
        this.secondaryValueFontConfiguration = builder.secondaryValueFontConfiguration;
        this.sparkline = builder.sparkline;
        this.visualLayoutOptions = builder.visualLayoutOptions;
    }

    public final ProgressBarOptions progressBar() {
        return this.progressBar;
    }

    public final TrendArrowOptions trendArrows() {
        return this.trendArrows;
    }

    public final SecondaryValueOptions secondaryValue() {
        return this.secondaryValue;
    }

    public final ComparisonConfiguration comparison() {
        return this.comparison;
    }

    public final PrimaryValueDisplayType primaryValueDisplayType() {
        return PrimaryValueDisplayType.fromValue(this.primaryValueDisplayType);
    }

    public final String primaryValueDisplayTypeAsString() {
        return this.primaryValueDisplayType;
    }

    public final FontConfiguration primaryValueFontConfiguration() {
        return this.primaryValueFontConfiguration;
    }

    public final FontConfiguration secondaryValueFontConfiguration() {
        return this.secondaryValueFontConfiguration;
    }

    public final KPISparklineOptions sparkline() {
        return this.sparkline;
    }

    public final KPIVisualLayoutOptions visualLayoutOptions() {
        return this.visualLayoutOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressBar());
        hashCode = 31 * hashCode + Objects.hashCode(this.trendArrows());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparison());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryValueDisplayTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryValueFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryValueFontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sparkline());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualLayoutOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPIOptions)) {
            return false;
        }
        KPIOptions other = (KPIOptions)obj;
        return Objects.equals(this.progressBar(), other.progressBar()) && Objects.equals(this.trendArrows(), other.trendArrows()) && Objects.equals(this.secondaryValue(), other.secondaryValue()) && Objects.equals(this.comparison(), other.comparison()) && Objects.equals(this.primaryValueDisplayTypeAsString(), other.primaryValueDisplayTypeAsString()) && Objects.equals(this.primaryValueFontConfiguration(), other.primaryValueFontConfiguration()) && Objects.equals(this.secondaryValueFontConfiguration(), other.secondaryValueFontConfiguration()) && Objects.equals(this.sparkline(), other.sparkline()) && Objects.equals(this.visualLayoutOptions(), other.visualLayoutOptions());
    }

    public final String toString() {
        return ToString.builder((String)"KPIOptions").add("ProgressBar", (Object)this.progressBar()).add("TrendArrows", (Object)this.trendArrows()).add("SecondaryValue", (Object)this.secondaryValue()).add("Comparison", (Object)this.comparison()).add("PrimaryValueDisplayType", (Object)this.primaryValueDisplayTypeAsString()).add("PrimaryValueFontConfiguration", (Object)this.primaryValueFontConfiguration()).add("SecondaryValueFontConfiguration", (Object)this.secondaryValueFontConfiguration()).add("Sparkline", (Object)this.sparkline()).add("VisualLayoutOptions", (Object)this.visualLayoutOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressBar": {
                return Optional.ofNullable(clazz.cast(this.progressBar()));
            }
            case "TrendArrows": {
                return Optional.ofNullable(clazz.cast(this.trendArrows()));
            }
            case "SecondaryValue": {
                return Optional.ofNullable(clazz.cast(this.secondaryValue()));
            }
            case "Comparison": {
                return Optional.ofNullable(clazz.cast(this.comparison()));
            }
            case "PrimaryValueDisplayType": {
                return Optional.ofNullable(clazz.cast(this.primaryValueDisplayTypeAsString()));
            }
            case "PrimaryValueFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.primaryValueFontConfiguration()));
            }
            case "SecondaryValueFontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.secondaryValueFontConfiguration()));
            }
            case "Sparkline": {
                return Optional.ofNullable(clazz.cast(this.sparkline()));
            }
            case "VisualLayoutOptions": {
                return Optional.ofNullable(clazz.cast(this.visualLayoutOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KPIOptions, T> g) {
        return obj -> g.apply((KPIOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ProgressBarOptions progressBar;
        private TrendArrowOptions trendArrows;
        private SecondaryValueOptions secondaryValue;
        private ComparisonConfiguration comparison;
        private String primaryValueDisplayType;
        private FontConfiguration primaryValueFontConfiguration;
        private FontConfiguration secondaryValueFontConfiguration;
        private KPISparklineOptions sparkline;
        private KPIVisualLayoutOptions visualLayoutOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(KPIOptions model) {
            this.progressBar(model.progressBar);
            this.trendArrows(model.trendArrows);
            this.secondaryValue(model.secondaryValue);
            this.comparison(model.comparison);
            this.primaryValueDisplayType(model.primaryValueDisplayType);
            this.primaryValueFontConfiguration(model.primaryValueFontConfiguration);
            this.secondaryValueFontConfiguration(model.secondaryValueFontConfiguration);
            this.sparkline(model.sparkline);
            this.visualLayoutOptions(model.visualLayoutOptions);
        }

        public final ProgressBarOptions.Builder getProgressBar() {
            return this.progressBar != null ? this.progressBar.toBuilder() : null;
        }

        public final void setProgressBar(ProgressBarOptions.BuilderImpl progressBar) {
            this.progressBar = progressBar != null ? progressBar.build() : null;
        }

        @Override
        public final Builder progressBar(ProgressBarOptions progressBar) {
            this.progressBar = progressBar;
            return this;
        }

        public final TrendArrowOptions.Builder getTrendArrows() {
            return this.trendArrows != null ? this.trendArrows.toBuilder() : null;
        }

        public final void setTrendArrows(TrendArrowOptions.BuilderImpl trendArrows) {
            this.trendArrows = trendArrows != null ? trendArrows.build() : null;
        }

        @Override
        public final Builder trendArrows(TrendArrowOptions trendArrows) {
            this.trendArrows = trendArrows;
            return this;
        }

        public final SecondaryValueOptions.Builder getSecondaryValue() {
            return this.secondaryValue != null ? this.secondaryValue.toBuilder() : null;
        }

        public final void setSecondaryValue(SecondaryValueOptions.BuilderImpl secondaryValue) {
            this.secondaryValue = secondaryValue != null ? secondaryValue.build() : null;
        }

        @Override
        public final Builder secondaryValue(SecondaryValueOptions secondaryValue) {
            this.secondaryValue = secondaryValue;
            return this;
        }

        public final ComparisonConfiguration.Builder getComparison() {
            return this.comparison != null ? this.comparison.toBuilder() : null;
        }

        public final void setComparison(ComparisonConfiguration.BuilderImpl comparison) {
            this.comparison = comparison != null ? comparison.build() : null;
        }

        @Override
        public final Builder comparison(ComparisonConfiguration comparison) {
            this.comparison = comparison;
            return this;
        }

        public final String getPrimaryValueDisplayType() {
            return this.primaryValueDisplayType;
        }

        public final void setPrimaryValueDisplayType(String primaryValueDisplayType) {
            this.primaryValueDisplayType = primaryValueDisplayType;
        }

        @Override
        public final Builder primaryValueDisplayType(String primaryValueDisplayType) {
            this.primaryValueDisplayType = primaryValueDisplayType;
            return this;
        }

        @Override
        public final Builder primaryValueDisplayType(PrimaryValueDisplayType primaryValueDisplayType) {
            this.primaryValueDisplayType(primaryValueDisplayType == null ? null : primaryValueDisplayType.toString());
            return this;
        }

        public final FontConfiguration.Builder getPrimaryValueFontConfiguration() {
            return this.primaryValueFontConfiguration != null ? this.primaryValueFontConfiguration.toBuilder() : null;
        }

        public final void setPrimaryValueFontConfiguration(FontConfiguration.BuilderImpl primaryValueFontConfiguration) {
            this.primaryValueFontConfiguration = primaryValueFontConfiguration != null ? primaryValueFontConfiguration.build() : null;
        }

        @Override
        public final Builder primaryValueFontConfiguration(FontConfiguration primaryValueFontConfiguration) {
            this.primaryValueFontConfiguration = primaryValueFontConfiguration;
            return this;
        }

        public final FontConfiguration.Builder getSecondaryValueFontConfiguration() {
            return this.secondaryValueFontConfiguration != null ? this.secondaryValueFontConfiguration.toBuilder() : null;
        }

        public final void setSecondaryValueFontConfiguration(FontConfiguration.BuilderImpl secondaryValueFontConfiguration) {
            this.secondaryValueFontConfiguration = secondaryValueFontConfiguration != null ? secondaryValueFontConfiguration.build() : null;
        }

        @Override
        public final Builder secondaryValueFontConfiguration(FontConfiguration secondaryValueFontConfiguration) {
            this.secondaryValueFontConfiguration = secondaryValueFontConfiguration;
            return this;
        }

        public final KPISparklineOptions.Builder getSparkline() {
            return this.sparkline != null ? this.sparkline.toBuilder() : null;
        }

        public final void setSparkline(KPISparklineOptions.BuilderImpl sparkline) {
            this.sparkline = sparkline != null ? sparkline.build() : null;
        }

        @Override
        public final Builder sparkline(KPISparklineOptions sparkline) {
            this.sparkline = sparkline;
            return this;
        }

        public final KPIVisualLayoutOptions.Builder getVisualLayoutOptions() {
            return this.visualLayoutOptions != null ? this.visualLayoutOptions.toBuilder() : null;
        }

        public final void setVisualLayoutOptions(KPIVisualLayoutOptions.BuilderImpl visualLayoutOptions) {
            this.visualLayoutOptions = visualLayoutOptions != null ? visualLayoutOptions.build() : null;
        }

        @Override
        public final Builder visualLayoutOptions(KPIVisualLayoutOptions visualLayoutOptions) {
            this.visualLayoutOptions = visualLayoutOptions;
            return this;
        }

        public KPIOptions build() {
            return new KPIOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KPIOptions> {
        public Builder progressBar(ProgressBarOptions var1);

        default public Builder progressBar(Consumer<ProgressBarOptions.Builder> progressBar) {
            return this.progressBar((ProgressBarOptions)((ProgressBarOptions.Builder)ProgressBarOptions.builder().applyMutation(progressBar)).build());
        }

        public Builder trendArrows(TrendArrowOptions var1);

        default public Builder trendArrows(Consumer<TrendArrowOptions.Builder> trendArrows) {
            return this.trendArrows((TrendArrowOptions)((TrendArrowOptions.Builder)TrendArrowOptions.builder().applyMutation(trendArrows)).build());
        }

        public Builder secondaryValue(SecondaryValueOptions var1);

        default public Builder secondaryValue(Consumer<SecondaryValueOptions.Builder> secondaryValue) {
            return this.secondaryValue((SecondaryValueOptions)((SecondaryValueOptions.Builder)SecondaryValueOptions.builder().applyMutation(secondaryValue)).build());
        }

        public Builder comparison(ComparisonConfiguration var1);

        default public Builder comparison(Consumer<ComparisonConfiguration.Builder> comparison) {
            return this.comparison((ComparisonConfiguration)((ComparisonConfiguration.Builder)ComparisonConfiguration.builder().applyMutation(comparison)).build());
        }

        public Builder primaryValueDisplayType(String var1);

        public Builder primaryValueDisplayType(PrimaryValueDisplayType var1);

        public Builder primaryValueFontConfiguration(FontConfiguration var1);

        default public Builder primaryValueFontConfiguration(Consumer<FontConfiguration.Builder> primaryValueFontConfiguration) {
            return this.primaryValueFontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(primaryValueFontConfiguration)).build());
        }

        public Builder secondaryValueFontConfiguration(FontConfiguration var1);

        default public Builder secondaryValueFontConfiguration(Consumer<FontConfiguration.Builder> secondaryValueFontConfiguration) {
            return this.secondaryValueFontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(secondaryValueFontConfiguration)).build());
        }

        public Builder sparkline(KPISparklineOptions var1);

        default public Builder sparkline(Consumer<KPISparklineOptions.Builder> sparkline) {
            return this.sparkline((KPISparklineOptions)((KPISparklineOptions.Builder)KPISparklineOptions.builder().applyMutation(sparkline)).build());
        }

        public Builder visualLayoutOptions(KPIVisualLayoutOptions var1);

        default public Builder visualLayoutOptions(Consumer<KPIVisualLayoutOptions.Builder> visualLayoutOptions) {
            return this.visualLayoutOptions((KPIVisualLayoutOptions)((KPIVisualLayoutOptions.Builder)KPIVisualLayoutOptions.builder().applyMutation(visualLayoutOptions)).build());
        }
    }
}

