/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CommitMode;
import software.amazon.awssdk.services.quicksight.model.RelativeDateTimeControlDisplayOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultRelativeDateTimeControlOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefaultRelativeDateTimeControlOptions> {
    private static final SdkField<RelativeDateTimeControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayOptions").getter(DefaultRelativeDateTimeControlOptions.getter(DefaultRelativeDateTimeControlOptions::displayOptions)).setter(DefaultRelativeDateTimeControlOptions.setter(Builder::displayOptions)).constructor(RelativeDateTimeControlDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()}).build();
    private static final SdkField<String> COMMIT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommitMode").getter(DefaultRelativeDateTimeControlOptions.getter(DefaultRelativeDateTimeControlOptions::commitModeAsString)).setter(DefaultRelativeDateTimeControlOptions.setter(Builder::commitMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_OPTIONS_FIELD, COMMIT_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DisplayOptions", DISPLAY_OPTIONS_FIELD);
            this.put("CommitMode", COMMIT_MODE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RelativeDateTimeControlDisplayOptions displayOptions;
    private final String commitMode;

    private DefaultRelativeDateTimeControlOptions(BuilderImpl builder) {
        this.displayOptions = builder.displayOptions;
        this.commitMode = builder.commitMode;
    }

    public final RelativeDateTimeControlDisplayOptions displayOptions() {
        return this.displayOptions;
    }

    public final CommitMode commitMode() {
        return CommitMode.fromValue(this.commitMode);
    }

    public final String commitModeAsString() {
        return this.commitMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.displayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultRelativeDateTimeControlOptions)) {
            return false;
        }
        DefaultRelativeDateTimeControlOptions other = (DefaultRelativeDateTimeControlOptions)obj;
        return Objects.equals(this.displayOptions(), other.displayOptions()) && Objects.equals(this.commitModeAsString(), other.commitModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DefaultRelativeDateTimeControlOptions").add("DisplayOptions", (Object)this.displayOptions()).add("CommitMode", (Object)this.commitModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayOptions": {
                return Optional.ofNullable(clazz.cast(this.displayOptions()));
            }
            case "CommitMode": {
                return Optional.ofNullable(clazz.cast(this.commitModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DefaultRelativeDateTimeControlOptions, T> g) {
        return obj -> g.apply((DefaultRelativeDateTimeControlOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RelativeDateTimeControlDisplayOptions displayOptions;
        private String commitMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultRelativeDateTimeControlOptions model) {
            this.displayOptions(model.displayOptions);
            this.commitMode(model.commitMode);
        }

        public final RelativeDateTimeControlDisplayOptions.Builder getDisplayOptions() {
            return this.displayOptions != null ? this.displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(RelativeDateTimeControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(RelativeDateTimeControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        public final String getCommitMode() {
            return this.commitMode;
        }

        public final void setCommitMode(String commitMode) {
            this.commitMode = commitMode;
        }

        @Override
        public final Builder commitMode(String commitMode) {
            this.commitMode = commitMode;
            return this;
        }

        @Override
        public final Builder commitMode(CommitMode commitMode) {
            this.commitMode(commitMode == null ? null : commitMode.toString());
            return this;
        }

        public DefaultRelativeDateTimeControlOptions build() {
            return new DefaultRelativeDateTimeControlOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefaultRelativeDateTimeControlOptions> {
        public Builder displayOptions(RelativeDateTimeControlDisplayOptions var1);

        default public Builder displayOptions(Consumer<RelativeDateTimeControlDisplayOptions.Builder> displayOptions) {
            return this.displayOptions((RelativeDateTimeControlDisplayOptions)((RelativeDateTimeControlDisplayOptions.Builder)RelativeDateTimeControlDisplayOptions.builder().applyMutation(displayOptions)).build());
        }

        public Builder commitMode(String var1);

        public Builder commitMode(CommitMode var1);
    }
}

