/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SpeechMarkType {
    SENTENCE("sentence"),
    SSML("ssml"),
    VISEME("viseme"),
    WORD("word"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SpeechMarkType> VALUE_MAP;
    private final String value;

    private SpeechMarkType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SpeechMarkType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SpeechMarkType> knownValues() {
        EnumSet<SpeechMarkType> knownValues = EnumSet.allOf(SpeechMarkType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SpeechMarkType.class, SpeechMarkType::toString);
    }
}

