/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeVerifiedDestinationNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.VerifiedDestinationNumberInformation;

public class DescribeVerifiedDestinationNumbersPublisher
implements SdkPublisher<DescribeVerifiedDestinationNumbersResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeVerifiedDestinationNumbersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVerifiedDestinationNumbersPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeVerifiedDestinationNumbersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVerifiedDestinationNumbersPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeVerifiedDestinationNumbersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVerifiedDestinationNumbersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVerifiedDestinationNumbersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VerifiedDestinationNumberInformation> verifiedDestinationNumbers() {
        Function<DescribeVerifiedDestinationNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.verifiedDestinationNumbers() != null) {
                return response.verifiedDestinationNumbers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeVerifiedDestinationNumbersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeVerifiedDestinationNumbersResponseFetcher
    implements AsyncPageFetcher<DescribeVerifiedDestinationNumbersResponse> {
        private DescribeVerifiedDestinationNumbersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVerifiedDestinationNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVerifiedDestinationNumbersResponse> nextPage(DescribeVerifiedDestinationNumbersResponse previousPage) {
            if (previousPage == null) {
                return DescribeVerifiedDestinationNumbersPublisher.this.client.describeVerifiedDestinationNumbers(DescribeVerifiedDestinationNumbersPublisher.this.firstRequest);
            }
            return DescribeVerifiedDestinationNumbersPublisher.this.client.describeVerifiedDestinationNumbers((DescribeVerifiedDestinationNumbersRequest)((Object)DescribeVerifiedDestinationNumbersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

