/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletePoolResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DeletePoolResponse> {
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolArn").getter(DeletePoolResponse.getter(DeletePoolResponse::poolArn)).setter(DeletePoolResponse.setter(Builder::poolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(DeletePoolResponse.getter(DeletePoolResponse::poolId)).setter(DeletePoolResponse.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DeletePoolResponse.getter(DeletePoolResponse::statusAsString)).setter(DeletePoolResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageType").getter(DeletePoolResponse.getter(DeletePoolResponse::messageTypeAsString)).setter(DeletePoolResponse.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()}).build();
    private static final SdkField<Boolean> TWO_WAY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TwoWayEnabled").getter(DeletePoolResponse.getter(DeletePoolResponse::twoWayEnabled)).setter(DeletePoolResponse.setter(Builder::twoWayEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayEnabled").build()}).build();
    private static final SdkField<String> TWO_WAY_CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TwoWayChannelArn").getter(DeletePoolResponse.getter(DeletePoolResponse::twoWayChannelArn)).setter(DeletePoolResponse.setter(Builder::twoWayChannelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelArn").build()}).build();
    private static final SdkField<String> TWO_WAY_CHANNEL_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TwoWayChannelRole").getter(DeletePoolResponse.getter(DeletePoolResponse::twoWayChannelRole)).setter(DeletePoolResponse.setter(Builder::twoWayChannelRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwoWayChannelRole").build()}).build();
    private static final SdkField<Boolean> SELF_MANAGED_OPT_OUTS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SelfManagedOptOutsEnabled").getter(DeletePoolResponse.getter(DeletePoolResponse::selfManagedOptOutsEnabled)).setter(DeletePoolResponse.setter(Builder::selfManagedOptOutsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedOptOutsEnabled").build()}).build();
    private static final SdkField<String> OPT_OUT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptOutListName").getter(DeletePoolResponse.getter(DeletePoolResponse::optOutListName)).setter(DeletePoolResponse.setter(Builder::optOutListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOutListName").build()}).build();
    private static final SdkField<Boolean> SHARED_ROUTES_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SharedRoutesEnabled").getter(DeletePoolResponse.getter(DeletePoolResponse::sharedRoutesEnabled)).setter(DeletePoolResponse.setter(Builder::sharedRoutesEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedRoutesEnabled").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(DeletePoolResponse.getter(DeletePoolResponse::createdTimestamp)).setter(DeletePoolResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ARN_FIELD, POOL_ID_FIELD, STATUS_FIELD, MESSAGE_TYPE_FIELD, TWO_WAY_ENABLED_FIELD, TWO_WAY_CHANNEL_ARN_FIELD, TWO_WAY_CHANNEL_ROLE_FIELD, SELF_MANAGED_OPT_OUTS_ENABLED_FIELD, OPT_OUT_LIST_NAME_FIELD, SHARED_ROUTES_ENABLED_FIELD, CREATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PoolArn", POOL_ARN_FIELD);
            this.put("PoolId", POOL_ID_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("MessageType", MESSAGE_TYPE_FIELD);
            this.put("TwoWayEnabled", TWO_WAY_ENABLED_FIELD);
            this.put("TwoWayChannelArn", TWO_WAY_CHANNEL_ARN_FIELD);
            this.put("TwoWayChannelRole", TWO_WAY_CHANNEL_ROLE_FIELD);
            this.put("SelfManagedOptOutsEnabled", SELF_MANAGED_OPT_OUTS_ENABLED_FIELD);
            this.put("OptOutListName", OPT_OUT_LIST_NAME_FIELD);
            this.put("SharedRoutesEnabled", SHARED_ROUTES_ENABLED_FIELD);
            this.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        }
    });
    private final String poolArn;
    private final String poolId;
    private final String status;
    private final String messageType;
    private final Boolean twoWayEnabled;
    private final String twoWayChannelArn;
    private final String twoWayChannelRole;
    private final Boolean selfManagedOptOutsEnabled;
    private final String optOutListName;
    private final Boolean sharedRoutesEnabled;
    private final Instant createdTimestamp;

    private DeletePoolResponse(BuilderImpl builder) {
        super(builder);
        this.poolArn = builder.poolArn;
        this.poolId = builder.poolId;
        this.status = builder.status;
        this.messageType = builder.messageType;
        this.twoWayEnabled = builder.twoWayEnabled;
        this.twoWayChannelArn = builder.twoWayChannelArn;
        this.twoWayChannelRole = builder.twoWayChannelRole;
        this.selfManagedOptOutsEnabled = builder.selfManagedOptOutsEnabled;
        this.optOutListName = builder.optOutListName;
        this.sharedRoutesEnabled = builder.sharedRoutesEnabled;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final String poolArn() {
        return this.poolArn;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final PoolStatus status() {
        return PoolStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public final String messageTypeAsString() {
        return this.messageType;
    }

    public final Boolean twoWayEnabled() {
        return this.twoWayEnabled;
    }

    public final String twoWayChannelArn() {
        return this.twoWayChannelArn;
    }

    public final String twoWayChannelRole() {
        return this.twoWayChannelRole;
    }

    public final Boolean selfManagedOptOutsEnabled() {
        return this.selfManagedOptOutsEnabled;
    }

    public final String optOutListName() {
        return this.optOutListName;
    }

    public final Boolean sharedRoutesEnabled() {
        return this.sharedRoutesEnabled;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.poolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.twoWayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.twoWayChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.twoWayChannelRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedOptOutsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.optOutListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedRoutesEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePoolResponse)) {
            return false;
        }
        DeletePoolResponse other = (DeletePoolResponse)((Object)obj);
        return Objects.equals(this.poolArn(), other.poolArn()) && Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString()) && Objects.equals(this.twoWayEnabled(), other.twoWayEnabled()) && Objects.equals(this.twoWayChannelArn(), other.twoWayChannelArn()) && Objects.equals(this.twoWayChannelRole(), other.twoWayChannelRole()) && Objects.equals(this.selfManagedOptOutsEnabled(), other.selfManagedOptOutsEnabled()) && Objects.equals(this.optOutListName(), other.optOutListName()) && Objects.equals(this.sharedRoutesEnabled(), other.sharedRoutesEnabled()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"DeletePoolResponse").add("PoolArn", (Object)this.poolArn()).add("PoolId", (Object)this.poolId()).add("Status", (Object)this.statusAsString()).add("MessageType", (Object)this.messageTypeAsString()).add("TwoWayEnabled", (Object)this.twoWayEnabled()).add("TwoWayChannelArn", (Object)this.twoWayChannelArn()).add("TwoWayChannelRole", (Object)this.twoWayChannelRole()).add("SelfManagedOptOutsEnabled", (Object)this.selfManagedOptOutsEnabled()).add("OptOutListName", (Object)this.optOutListName()).add("SharedRoutesEnabled", (Object)this.sharedRoutesEnabled()).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolArn": {
                return Optional.ofNullable(clazz.cast(this.poolArn()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
            case "TwoWayEnabled": {
                return Optional.ofNullable(clazz.cast(this.twoWayEnabled()));
            }
            case "TwoWayChannelArn": {
                return Optional.ofNullable(clazz.cast(this.twoWayChannelArn()));
            }
            case "TwoWayChannelRole": {
                return Optional.ofNullable(clazz.cast(this.twoWayChannelRole()));
            }
            case "SelfManagedOptOutsEnabled": {
                return Optional.ofNullable(clazz.cast(this.selfManagedOptOutsEnabled()));
            }
            case "OptOutListName": {
                return Optional.ofNullable(clazz.cast(this.optOutListName()));
            }
            case "SharedRoutesEnabled": {
                return Optional.ofNullable(clazz.cast(this.sharedRoutesEnabled()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeletePoolResponse, T> g) {
        return obj -> g.apply((DeletePoolResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String poolArn;
        private String poolId;
        private String status;
        private String messageType;
        private Boolean twoWayEnabled;
        private String twoWayChannelArn;
        private String twoWayChannelRole;
        private Boolean selfManagedOptOutsEnabled;
        private String optOutListName;
        private Boolean sharedRoutesEnabled;
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePoolResponse model) {
            super(model);
            this.poolArn(model.poolArn);
            this.poolId(model.poolId);
            this.status(model.status);
            this.messageType(model.messageType);
            this.twoWayEnabled(model.twoWayEnabled);
            this.twoWayChannelArn(model.twoWayChannelArn);
            this.twoWayChannelRole(model.twoWayChannelRole);
            this.selfManagedOptOutsEnabled(model.selfManagedOptOutsEnabled);
            this.optOutListName(model.optOutListName);
            this.sharedRoutesEnabled(model.sharedRoutesEnabled);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getPoolArn() {
            return this.poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PoolStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final Boolean getTwoWayEnabled() {
            return this.twoWayEnabled;
        }

        public final void setTwoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
        }

        @Override
        public final Builder twoWayEnabled(Boolean twoWayEnabled) {
            this.twoWayEnabled = twoWayEnabled;
            return this;
        }

        public final String getTwoWayChannelArn() {
            return this.twoWayChannelArn;
        }

        public final void setTwoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
        }

        @Override
        public final Builder twoWayChannelArn(String twoWayChannelArn) {
            this.twoWayChannelArn = twoWayChannelArn;
            return this;
        }

        public final String getTwoWayChannelRole() {
            return this.twoWayChannelRole;
        }

        public final void setTwoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
        }

        @Override
        public final Builder twoWayChannelRole(String twoWayChannelRole) {
            this.twoWayChannelRole = twoWayChannelRole;
            return this;
        }

        public final Boolean getSelfManagedOptOutsEnabled() {
            return this.selfManagedOptOutsEnabled;
        }

        public final void setSelfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
        }

        @Override
        public final Builder selfManagedOptOutsEnabled(Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        public final String getOptOutListName() {
            return this.optOutListName;
        }

        public final void setOptOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
        }

        @Override
        public final Builder optOutListName(String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        public final Boolean getSharedRoutesEnabled() {
            return this.sharedRoutesEnabled;
        }

        public final void setSharedRoutesEnabled(Boolean sharedRoutesEnabled) {
            this.sharedRoutesEnabled = sharedRoutesEnabled;
        }

        @Override
        public final Builder sharedRoutesEnabled(Boolean sharedRoutesEnabled) {
            this.sharedRoutesEnabled = sharedRoutesEnabled;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public DeletePoolResponse build() {
            return new DeletePoolResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeletePoolResponse> {
        public Builder poolArn(String var1);

        public Builder poolId(String var1);

        public Builder status(String var1);

        public Builder status(PoolStatus var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder twoWayEnabled(Boolean var1);

        public Builder twoWayChannelArn(String var1);

        public Builder twoWayChannelRole(String var1);

        public Builder selfManagedOptOutsEnabled(Boolean var1);

        public Builder optOutListName(String var1);

        public Builder sharedRoutesEnabled(Boolean var1);

        public Builder createdTimestamp(Instant var1);
    }
}

