/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesResponse;
import software.amazon.awssdk.services.outposts.model.InstanceTypeItem;

public class GetOutpostSupportedInstanceTypesIterable
implements SdkIterable<GetOutpostSupportedInstanceTypesResponse> {
    private final OutpostsClient client;
    private final GetOutpostSupportedInstanceTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetOutpostSupportedInstanceTypesIterable(OutpostsClient client, GetOutpostSupportedInstanceTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetOutpostSupportedInstanceTypesResponseFetcher();
    }

    public Iterator<GetOutpostSupportedInstanceTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceTypeItem> instanceTypes() {
        Function<GetOutpostSupportedInstanceTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceTypes() != null) {
                return response.instanceTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetOutpostSupportedInstanceTypesResponseFetcher
    implements SyncPageFetcher<GetOutpostSupportedInstanceTypesResponse> {
        private GetOutpostSupportedInstanceTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetOutpostSupportedInstanceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetOutpostSupportedInstanceTypesResponse nextPage(GetOutpostSupportedInstanceTypesResponse previousPage) {
            if (previousPage == null) {
                return GetOutpostSupportedInstanceTypesIterable.this.client.getOutpostSupportedInstanceTypes(GetOutpostSupportedInstanceTypesIterable.this.firstRequest);
            }
            return GetOutpostSupportedInstanceTypesIterable.this.client.getOutpostSupportedInstanceTypes((GetOutpostSupportedInstanceTypesRequest)((Object)GetOutpostSupportedInstanceTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

