/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.services.opensearch.model.ScheduleAt;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartServiceSoftwareUpdateRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, StartServiceSoftwareUpdateRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(StartServiceSoftwareUpdateRequest.getter(StartServiceSoftwareUpdateRequest::domainName)).setter(StartServiceSoftwareUpdateRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> SCHEDULE_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleAt").getter(StartServiceSoftwareUpdateRequest.getter(StartServiceSoftwareUpdateRequest::scheduleAtAsString)).setter(StartServiceSoftwareUpdateRequest.setter(Builder::scheduleAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleAt").build()}).build();
    private static final SdkField<Long> DESIRED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DesiredStartTime").getter(StartServiceSoftwareUpdateRequest.getter(StartServiceSoftwareUpdateRequest::desiredStartTime)).setter(StartServiceSoftwareUpdateRequest.setter(Builder::desiredStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, SCHEDULE_AT_FIELD, DESIRED_START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("ScheduleAt", SCHEDULE_AT_FIELD);
            this.put("DesiredStartTime", DESIRED_START_TIME_FIELD);
        }
    });
    private final String domainName;
    private final String scheduleAt;
    private final Long desiredStartTime;

    private StartServiceSoftwareUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.scheduleAt = builder.scheduleAt;
        this.desiredStartTime = builder.desiredStartTime;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final ScheduleAt scheduleAt() {
        return ScheduleAt.fromValue(this.scheduleAt);
    }

    public final String scheduleAtAsString() {
        return this.scheduleAt;
    }

    public final Long desiredStartTime() {
        return this.desiredStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleAtAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartServiceSoftwareUpdateRequest)) {
            return false;
        }
        StartServiceSoftwareUpdateRequest other = (StartServiceSoftwareUpdateRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.scheduleAtAsString(), other.scheduleAtAsString()) && Objects.equals(this.desiredStartTime(), other.desiredStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"StartServiceSoftwareUpdateRequest").add("DomainName", (Object)this.domainName()).add("ScheduleAt", (Object)this.scheduleAtAsString()).add("DesiredStartTime", (Object)this.desiredStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ScheduleAt": {
                return Optional.ofNullable(clazz.cast(this.scheduleAtAsString()));
            }
            case "DesiredStartTime": {
                return Optional.ofNullable(clazz.cast(this.desiredStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartServiceSoftwareUpdateRequest, T> g) {
        return obj -> g.apply((StartServiceSoftwareUpdateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String scheduleAt;
        private Long desiredStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartServiceSoftwareUpdateRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.scheduleAt(model.scheduleAt);
            this.desiredStartTime(model.desiredStartTime);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getScheduleAt() {
            return this.scheduleAt;
        }

        public final void setScheduleAt(String scheduleAt) {
            this.scheduleAt = scheduleAt;
        }

        @Override
        public final Builder scheduleAt(String scheduleAt) {
            this.scheduleAt = scheduleAt;
            return this;
        }

        @Override
        public final Builder scheduleAt(ScheduleAt scheduleAt) {
            this.scheduleAt(scheduleAt == null ? null : scheduleAt.toString());
            return this;
        }

        public final Long getDesiredStartTime() {
            return this.desiredStartTime;
        }

        public final void setDesiredStartTime(Long desiredStartTime) {
            this.desiredStartTime = desiredStartTime;
        }

        @Override
        public final Builder desiredStartTime(Long desiredStartTime) {
            this.desiredStartTime = desiredStartTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartServiceSoftwareUpdateRequest build() {
            return new StartServiceSoftwareUpdateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartServiceSoftwareUpdateRequest> {
        public Builder domainName(String var1);

        public Builder scheduleAt(String var1);

        public Builder scheduleAt(ScheduleAt var1);

        public Builder desiredStartTime(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

