/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.EdgeOverride;
import software.amazon.awssdk.services.networkmanager.model.NetworkFunctionGroup;
import software.amazon.awssdk.services.networkmanager.model.NetworkFunctionGroupListCopier;
import software.amazon.awssdk.services.networkmanager.model.WithEdgeOverridesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Via
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Via> {
    private static final SdkField<List<NetworkFunctionGroup>> NETWORK_FUNCTION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkFunctionGroups").getter(Via.getter(Via::networkFunctionGroups)).setter(Via.setter(Builder::networkFunctionGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFunctionGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkFunctionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EdgeOverride>> WITH_EDGE_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WithEdgeOverrides").getter(Via.getter(Via::withEdgeOverrides)).setter(Via.setter(Builder::withEdgeOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithEdgeOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EdgeOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FUNCTION_GROUPS_FIELD, WITH_EDGE_OVERRIDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NetworkFunctionGroups", NETWORK_FUNCTION_GROUPS_FIELD);
            this.put("WithEdgeOverrides", WITH_EDGE_OVERRIDES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<NetworkFunctionGroup> networkFunctionGroups;
    private final List<EdgeOverride> withEdgeOverrides;

    private Via(BuilderImpl builder) {
        this.networkFunctionGroups = builder.networkFunctionGroups;
        this.withEdgeOverrides = builder.withEdgeOverrides;
    }

    public final boolean hasNetworkFunctionGroups() {
        return this.networkFunctionGroups != null && !(this.networkFunctionGroups instanceof SdkAutoConstructList);
    }

    public final List<NetworkFunctionGroup> networkFunctionGroups() {
        return this.networkFunctionGroups;
    }

    public final boolean hasWithEdgeOverrides() {
        return this.withEdgeOverrides != null && !(this.withEdgeOverrides instanceof SdkAutoConstructList);
    }

    public final List<EdgeOverride> withEdgeOverrides() {
        return this.withEdgeOverrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkFunctionGroups() ? this.networkFunctionGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWithEdgeOverrides() ? this.withEdgeOverrides() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Via)) {
            return false;
        }
        Via other = (Via)obj;
        return this.hasNetworkFunctionGroups() == other.hasNetworkFunctionGroups() && Objects.equals(this.networkFunctionGroups(), other.networkFunctionGroups()) && this.hasWithEdgeOverrides() == other.hasWithEdgeOverrides() && Objects.equals(this.withEdgeOverrides(), other.withEdgeOverrides());
    }

    public final String toString() {
        return ToString.builder((String)"Via").add("NetworkFunctionGroups", this.hasNetworkFunctionGroups() ? this.networkFunctionGroups() : null).add("WithEdgeOverrides", this.hasWithEdgeOverrides() ? this.withEdgeOverrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkFunctionGroups": {
                return Optional.ofNullable(clazz.cast(this.networkFunctionGroups()));
            }
            case "WithEdgeOverrides": {
                return Optional.ofNullable(clazz.cast(this.withEdgeOverrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Via, T> g) {
        return obj -> g.apply((Via)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<NetworkFunctionGroup> networkFunctionGroups = DefaultSdkAutoConstructList.getInstance();
        private List<EdgeOverride> withEdgeOverrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Via model) {
            this.networkFunctionGroups(model.networkFunctionGroups);
            this.withEdgeOverrides(model.withEdgeOverrides);
        }

        public final List<NetworkFunctionGroup.Builder> getNetworkFunctionGroups() {
            List<NetworkFunctionGroup.Builder> result = NetworkFunctionGroupListCopier.copyToBuilder(this.networkFunctionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkFunctionGroups(Collection<NetworkFunctionGroup.BuilderImpl> networkFunctionGroups) {
            this.networkFunctionGroups = NetworkFunctionGroupListCopier.copyFromBuilder(networkFunctionGroups);
        }

        @Override
        public final Builder networkFunctionGroups(Collection<NetworkFunctionGroup> networkFunctionGroups) {
            this.networkFunctionGroups = NetworkFunctionGroupListCopier.copy(networkFunctionGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkFunctionGroups(NetworkFunctionGroup ... networkFunctionGroups) {
            this.networkFunctionGroups(Arrays.asList(networkFunctionGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkFunctionGroups(Consumer<NetworkFunctionGroup.Builder> ... networkFunctionGroups) {
            this.networkFunctionGroups(Stream.of(networkFunctionGroups).map(c -> (NetworkFunctionGroup)((NetworkFunctionGroup.Builder)NetworkFunctionGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EdgeOverride.Builder> getWithEdgeOverrides() {
            List<EdgeOverride.Builder> result = WithEdgeOverridesListCopier.copyToBuilder(this.withEdgeOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWithEdgeOverrides(Collection<EdgeOverride.BuilderImpl> withEdgeOverrides) {
            this.withEdgeOverrides = WithEdgeOverridesListCopier.copyFromBuilder(withEdgeOverrides);
        }

        @Override
        public final Builder withEdgeOverrides(Collection<EdgeOverride> withEdgeOverrides) {
            this.withEdgeOverrides = WithEdgeOverridesListCopier.copy(withEdgeOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder withEdgeOverrides(EdgeOverride ... withEdgeOverrides) {
            this.withEdgeOverrides(Arrays.asList(withEdgeOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder withEdgeOverrides(Consumer<EdgeOverride.Builder> ... withEdgeOverrides) {
            this.withEdgeOverrides(Stream.of(withEdgeOverrides).map(c -> (EdgeOverride)((EdgeOverride.Builder)EdgeOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Via build() {
            return new Via(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Via> {
        public Builder networkFunctionGroups(Collection<NetworkFunctionGroup> var1);

        public Builder networkFunctionGroups(NetworkFunctionGroup ... var1);

        public Builder networkFunctionGroups(Consumer<NetworkFunctionGroup.Builder> ... var1);

        public Builder withEdgeOverrides(Collection<EdgeOverride> var1);

        public Builder withEdgeOverrides(EdgeOverride ... var1);

        public Builder withEdgeOverrides(Consumer<EdgeOverride.Builder> ... var1);
    }
}

