/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunedata.model.EdgePropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgeStructure
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgeStructure> {
    private static final SdkField<Long> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("count").getter(EdgeStructure.getter(EdgeStructure::count)).setter(EdgeStructure.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<List<String>> EDGE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("edgeProperties").getter(EdgeStructure.getter(EdgeStructure::edgeProperties)).setter(EdgeStructure.setter(Builder::edgeProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("edgeProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, EDGE_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("count", COUNT_FIELD);
            this.put("edgeProperties", EDGE_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long count;
    private final List<String> edgeProperties;

    private EdgeStructure(BuilderImpl builder) {
        this.count = builder.count;
        this.edgeProperties = builder.edgeProperties;
    }

    public final Long count() {
        return this.count;
    }

    public final boolean hasEdgeProperties() {
        return this.edgeProperties != null && !(this.edgeProperties instanceof SdkAutoConstructList);
    }

    public final List<String> edgeProperties() {
        return this.edgeProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdgeProperties() ? this.edgeProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeStructure)) {
            return false;
        }
        EdgeStructure other = (EdgeStructure)obj;
        return Objects.equals(this.count(), other.count()) && this.hasEdgeProperties() == other.hasEdgeProperties() && Objects.equals(this.edgeProperties(), other.edgeProperties());
    }

    public final String toString() {
        return ToString.builder((String)"EdgeStructure").add("Count", (Object)this.count()).add("EdgeProperties", this.hasEdgeProperties() ? this.edgeProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "edgeProperties": {
                return Optional.ofNullable(clazz.cast(this.edgeProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EdgeStructure, T> g) {
        return obj -> g.apply((EdgeStructure)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long count;
        private List<String> edgeProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeStructure model) {
            this.count(model.count);
            this.edgeProperties(model.edgeProperties);
        }

        public final Long getCount() {
            return this.count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final Collection<String> getEdgeProperties() {
            if (this.edgeProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.edgeProperties;
        }

        public final void setEdgeProperties(Collection<String> edgeProperties) {
            this.edgeProperties = EdgePropertiesCopier.copy(edgeProperties);
        }

        @Override
        public final Builder edgeProperties(Collection<String> edgeProperties) {
            this.edgeProperties = EdgePropertiesCopier.copy(edgeProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeProperties(String ... edgeProperties) {
            this.edgeProperties(Arrays.asList(edgeProperties));
            return this;
        }

        public EdgeStructure build() {
            return new EdgeStructure(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgeStructure> {
        public Builder count(Long var1);

        public Builder edgeProperties(Collection<String> var1);

        public Builder edgeProperties(String ... var1);
    }
}

