/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelMlModelTransformJobRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, CancelMlModelTransformJobRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CancelMlModelTransformJobRequest.getter(CancelMlModelTransformJobRequest::id)).setter(CancelMlModelTransformJobRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> NEPTUNE_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("neptuneIamRoleArn").getter(CancelMlModelTransformJobRequest.getter(CancelMlModelTransformJobRequest::neptuneIamRoleArn)).setter(CancelMlModelTransformJobRequest.setter(Builder::neptuneIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("neptuneIamRoleArn").build()}).build();
    private static final SdkField<Boolean> CLEAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("clean").getter(CancelMlModelTransformJobRequest.getter(CancelMlModelTransformJobRequest::clean)).setter(CancelMlModelTransformJobRequest.setter(Builder::clean)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clean").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NEPTUNE_IAM_ROLE_ARN_FIELD, CLEAN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("neptuneIamRoleArn", NEPTUNE_IAM_ROLE_ARN_FIELD);
            this.put("clean", CLEAN_FIELD);
        }
    });
    private final String id;
    private final String neptuneIamRoleArn;
    private final Boolean clean;

    private CancelMlModelTransformJobRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.neptuneIamRoleArn = builder.neptuneIamRoleArn;
        this.clean = builder.clean;
    }

    public final String id() {
        return this.id;
    }

    public final String neptuneIamRoleArn() {
        return this.neptuneIamRoleArn;
    }

    public final Boolean clean() {
        return this.clean;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.neptuneIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clean());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelMlModelTransformJobRequest)) {
            return false;
        }
        CancelMlModelTransformJobRequest other = (CancelMlModelTransformJobRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.neptuneIamRoleArn(), other.neptuneIamRoleArn()) && Objects.equals(this.clean(), other.clean());
    }

    public final String toString() {
        return ToString.builder((String)"CancelMlModelTransformJobRequest").add("Id", (Object)this.id()).add("NeptuneIamRoleArn", (Object)this.neptuneIamRoleArn()).add("Clean", (Object)this.clean()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "neptuneIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.neptuneIamRoleArn()));
            }
            case "clean": {
                return Optional.ofNullable(clazz.cast(this.clean()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CancelMlModelTransformJobRequest, T> g) {
        return obj -> g.apply((CancelMlModelTransformJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private String id;
        private String neptuneIamRoleArn;
        private Boolean clean;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelMlModelTransformJobRequest model) {
            super(model);
            this.id(model.id);
            this.neptuneIamRoleArn(model.neptuneIamRoleArn);
            this.clean(model.clean);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getNeptuneIamRoleArn() {
            return this.neptuneIamRoleArn;
        }

        public final void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
        }

        @Override
        public final Builder neptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
            return this;
        }

        public final Boolean getClean() {
            return this.clean;
        }

        public final void setClean(Boolean clean) {
            this.clean = clean;
        }

        @Override
        public final Builder clean(Boolean clean) {
            this.clean = clean;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelMlModelTransformJobRequest build() {
            return new CancelMlModelTransformJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelMlModelTransformJobRequest> {
        public Builder id(String var1);

        public Builder neptuneIamRoleArn(String var1);

        public Builder clean(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

