/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.services.mturk.model.ReviewableHITStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReviewableHiTsRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, ListReviewableHiTsRequest> {
    private static final SdkField<String> HIT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HITTypeId").getter(ListReviewableHiTsRequest.getter(ListReviewableHiTsRequest::hitTypeId)).setter(ListReviewableHiTsRequest.setter(Builder::hitTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITTypeId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListReviewableHiTsRequest.getter(ListReviewableHiTsRequest::statusAsString)).setter(ListReviewableHiTsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReviewableHiTsRequest.getter(ListReviewableHiTsRequest::nextToken)).setter(ListReviewableHiTsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListReviewableHiTsRequest.getter(ListReviewableHiTsRequest::maxResults)).setter(ListReviewableHiTsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIT_TYPE_ID_FIELD, STATUS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("HITTypeId", HIT_TYPE_ID_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
        }
    });
    private final String hitTypeId;
    private final String status;
    private final String nextToken;
    private final Integer maxResults;

    private ListReviewableHiTsRequest(BuilderImpl builder) {
        super(builder);
        this.hitTypeId = builder.hitTypeId;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String hitTypeId() {
        return this.hitTypeId;
    }

    public final ReviewableHITStatus status() {
        return ReviewableHITStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hitTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReviewableHiTsRequest)) {
            return false;
        }
        ListReviewableHiTsRequest other = (ListReviewableHiTsRequest)((Object)obj);
        return Objects.equals(this.hitTypeId(), other.hitTypeId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListReviewableHiTsRequest").add("HITTypeId", (Object)this.hitTypeId()).add("Status", (Object)this.statusAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITTypeId": {
                return Optional.ofNullable(clazz.cast(this.hitTypeId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListReviewableHiTsRequest, T> g) {
        return obj -> g.apply((ListReviewableHiTsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String hitTypeId;
        private String status;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReviewableHiTsRequest model) {
            super(model);
            this.hitTypeId(model.hitTypeId);
            this.status(model.status);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getHitTypeId() {
            return this.hitTypeId;
        }

        public final void setHitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
        }

        @Override
        public final Builder hitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReviewableHITStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReviewableHiTsRequest build() {
            return new ListReviewableHiTsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReviewableHiTsRequest> {
        public Builder hitTypeId(String var1);

        public Builder status(String var1);

        public Builder status(ReviewableHITStatus var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

