/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.PluginSummariesCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.PluginSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPluginsResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, ListPluginsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPluginsResponse.getter(ListPluginsResponse::nextToken)).setter(ListPluginsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<PluginSummary>> PLUGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("plugins").getter(ListPluginsResponse.getter(ListPluginsResponse::plugins)).setter(ListPluginsResponse.setter(Builder::plugins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plugins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PluginSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PLUGINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("plugins", PLUGINS_FIELD);
        }
    });
    private final String nextToken;
    private final List<PluginSummary> plugins;

    private ListPluginsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.plugins = builder.plugins;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPlugins() {
        return this.plugins != null && !(this.plugins instanceof SdkAutoConstructList);
    }

    public final List<PluginSummary> plugins() {
        return this.plugins;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlugins() ? this.plugins() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPluginsResponse)) {
            return false;
        }
        ListPluginsResponse other = (ListPluginsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPlugins() == other.hasPlugins() && Objects.equals(this.plugins(), other.plugins());
    }

    public final String toString() {
        return ToString.builder((String)"ListPluginsResponse").add("NextToken", (Object)this.nextToken()).add("Plugins", this.hasPlugins() ? this.plugins() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "plugins": {
                return Optional.ofNullable(clazz.cast(this.plugins()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPluginsResponse, T> g) {
        return obj -> g.apply((ListPluginsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PluginSummary> plugins = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPluginsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.plugins(model.plugins);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PluginSummary.Builder> getPlugins() {
            List<PluginSummary.Builder> result = PluginSummariesCopier.copyToBuilder(this.plugins);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlugins(Collection<PluginSummary.BuilderImpl> plugins) {
            this.plugins = PluginSummariesCopier.copyFromBuilder(plugins);
        }

        @Override
        public final Builder plugins(Collection<PluginSummary> plugins) {
            this.plugins = PluginSummariesCopier.copy(plugins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder plugins(PluginSummary ... plugins) {
            this.plugins(Arrays.asList(plugins));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder plugins(Consumer<PluginSummary.Builder> ... plugins) {
            this.plugins(Stream.of(plugins).map(c -> (PluginSummary)((PluginSummary.Builder)PluginSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPluginsResponse build() {
            return new ListPluginsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPluginsResponse> {
        public Builder nextToken(String var1);

        public Builder plugins(Collection<PluginSummary> var1);

        public Builder plugins(PluginSummary ... var1);

        public Builder plugins(Consumer<PluginSummary.Builder> ... var1);
    }
}

